% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codestar_operations.R
\name{codestar_list_resources}
\alias{codestar_list_resources}
\title{Lists resources associated with a project in AWS CodeStar}
\usage{
codestar_list_resources(projectId, nextToken, maxResults)
}
\arguments{
\item{projectId}{[required] The ID of the project.}

\item{nextToken}{The continuation token for the next set of results, if the results
cannot be returned in one response.}

\item{maxResults}{The maximum amount of data that can be contained in a single set of
results.}
}
\value{
A list with the following syntax:\preformatted{list(
  resources = list(
    list(
      id = "string"
    )
  ),
  nextToken = "string"
)
}
}
\description{
Lists resources associated with a project in AWS CodeStar.
}
\section{Request syntax}{
\preformatted{svc$list_resources(
  projectId = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
