% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_restore_from_cluster_snapshot}
\alias{redshift_restore_from_cluster_snapshot}
\title{Creates a new cluster from a snapshot}
\usage{
redshift_restore_from_cluster_snapshot(
  ClusterIdentifier,
  SnapshotIdentifier = NULL,
  SnapshotArn = NULL,
  SnapshotClusterIdentifier = NULL,
  Port = NULL,
  AvailabilityZone = NULL,
  AllowVersionUpgrade = NULL,
  ClusterSubnetGroupName = NULL,
  PubliclyAccessible = NULL,
  OwnerAccount = NULL,
  HsmClientCertificateIdentifier = NULL,
  HsmConfigurationIdentifier = NULL,
  ElasticIp = NULL,
  ClusterParameterGroupName = NULL,
  ClusterSecurityGroups = NULL,
  VpcSecurityGroupIds = NULL,
  PreferredMaintenanceWindow = NULL,
  AutomatedSnapshotRetentionPeriod = NULL,
  ManualSnapshotRetentionPeriod = NULL,
  KmsKeyId = NULL,
  NodeType = NULL,
  EnhancedVpcRouting = NULL,
  AdditionalInfo = NULL,
  IamRoles = NULL,
  MaintenanceTrackName = NULL,
  SnapshotScheduleIdentifier = NULL,
  NumberOfNodes = NULL,
  AvailabilityZoneRelocation = NULL,
  AquaConfigurationStatus = NULL,
  DefaultIamRoleArn = NULL,
  ReservedNodeId = NULL,
  TargetReservedNodeOfferingId = NULL,
  Encrypted = NULL,
  ManageMasterPassword = NULL,
  MasterPasswordSecretKmsKeyId = NULL,
  IpAddressType = NULL,
  MultiAZ = NULL
)
}
\arguments{
\item{ClusterIdentifier}{[required] The identifier of the cluster that will be created from restoring the
snapshot.

Constraints:
\itemize{
\item Must contain from 1 to 63 alphanumeric characters or hyphens.
\item Alphabetic characters must be lowercase.
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
\item Must be unique for all clusters within an Amazon Web Services
account.
}}

\item{SnapshotIdentifier}{The name of the snapshot from which to create the new cluster. This
parameter isn't case sensitive. You must specify this parameter or
\code{snapshotArn}, but not both.

Example: \code{my-snapshot-id}}

\item{SnapshotArn}{The Amazon Resource Name (ARN) of the snapshot associated with the
message to restore from a cluster. You must specify this parameter or
\code{snapshotIdentifier}, but not both.}

\item{SnapshotClusterIdentifier}{The name of the cluster the source snapshot was created from. This
parameter is required if your IAM user has a policy containing a
snapshot resource element that specifies anything other than * for the
cluster name.}

\item{Port}{The port number on which the cluster accepts connections.

Default: The same port as the original cluster.

Valid values: For clusters with DC2 nodes, must be within the range
\code{1150}-\code{65535}. For clusters with ra3 nodes, must be within the ranges
\code{5431}-\code{5455} or \code{8191}-\code{8215}.}

\item{AvailabilityZone}{The Amazon EC2 Availability Zone in which to restore the cluster.

Default: A random, system-chosen Availability Zone.

Example: \verb{us-east-2a}}

\item{AllowVersionUpgrade}{If \code{true}, major version upgrades can be applied during the maintenance
window to the Amazon Redshift engine that is running on the cluster.

Default: \code{true}}

\item{ClusterSubnetGroupName}{The name of the subnet group where you want to cluster restored.

A snapshot of cluster in VPC can be restored only in VPC. Therefore, you
must provide subnet group name where you want the cluster restored.}

\item{PubliclyAccessible}{If \code{true}, the cluster can be accessed from a public network.}

\item{OwnerAccount}{The Amazon Web Services account used to create or copy the snapshot.
Required if you are restoring a snapshot you do not own, optional if you
own the snapshot.}

\item{HsmClientCertificateIdentifier}{Specifies the name of the HSM client certificate the Amazon Redshift
cluster uses to retrieve the data encryption keys stored in an HSM.}

\item{HsmConfigurationIdentifier}{Specifies the name of the HSM configuration that contains the
information the Amazon Redshift cluster can use to retrieve and store
keys in an HSM.}

\item{ElasticIp}{The Elastic IP (EIP) address for the cluster. Don't specify the Elastic
IP address for a publicly accessible cluster with availability zone
relocation turned on.}

\item{ClusterParameterGroupName}{The name of the parameter group to be associated with this cluster.

Default: The default Amazon Redshift cluster parameter group. For
information about the default parameter group, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html}{Working with Amazon Redshift Parameter Groups}.

Constraints:
\itemize{
\item Must be 1 to 255 alphanumeric characters or hyphens.
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}}

\item{ClusterSecurityGroups}{A list of security groups to be associated with this cluster.

Default: The default cluster security group for Amazon Redshift.

Cluster security groups only apply to clusters outside of VPCs.}

\item{VpcSecurityGroupIds}{A list of Virtual Private Cloud (VPC) security groups to be associated
with the cluster.

Default: The default VPC security group is associated with the cluster.

VPC security groups only apply to clusters in VPCs.}

\item{PreferredMaintenanceWindow}{The weekly time range (in UTC) during which automated cluster
maintenance can occur.

Format: \code{ddd:hh24:mi-ddd:hh24:mi}

Default: The value selected for the cluster from which the snapshot was
taken. For more information about the time blocks for each region, see
\href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows}{Maintenance Windows}
in Amazon Redshift Cluster Management Guide.

Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun

Constraints: Minimum 30-minute window.}

\item{AutomatedSnapshotRetentionPeriod}{The number of days that automated snapshots are retained. If the value
is 0, automated snapshots are disabled. Even if automated snapshots are
disabled, you can still create manual snapshots when you want with
\code{\link[=redshift_create_cluster_snapshot]{create_cluster_snapshot}}.

You can't disable automated snapshots for RA3 node types. Set the
automated retention period from 1-35 days.

Default: The value selected for the cluster from which the snapshot was
taken.

Constraints: Must be a value from 0 to 35.}

\item{ManualSnapshotRetentionPeriod}{The default number of days to retain a manual snapshot. If the value is
-1, the snapshot is retained indefinitely. This setting doesn't change
the retention period of existing snapshots.

The value must be either -1 or an integer between 1 and 3,653.}

\item{KmsKeyId}{The Key Management Service (KMS) key ID of the encryption key that
encrypts data in the cluster restored from a shared snapshot. You can
also provide the key ID when you restore from an unencrypted snapshot to
an encrypted cluster in the same account. Additionally, you can specify
a new KMS key ID when you restore from an encrypted snapshot in the same
account in order to change it. In that case, the restored cluster is
encrypted with the new KMS key ID.}

\item{NodeType}{The node type that the restored cluster will be provisioned with.

If you have a DC instance type, you must restore into that same instance
type and size. In other words, you can only restore a dc2.large node
type into another dc2 type. For more information about node types, see
\href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes}{About Clusters and Nodes}
in the \emph{Amazon Redshift Cluster Management Guide}.}

\item{EnhancedVpcRouting}{An option that specifies whether to create the cluster with enhanced VPC
routing enabled. To create a cluster that uses enhanced VPC routing, the
cluster must be in a VPC. For more information, see \href{https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html}{Enhanced VPC Routing}
in the Amazon Redshift Cluster Management Guide.

If this option is \code{true}, enhanced VPC routing is enabled.

Default: false}

\item{AdditionalInfo}{Reserved.}

\item{IamRoles}{A list of Identity and Access Management (IAM) roles that can be used by
the cluster to access other Amazon Web Services services. You must
supply the IAM roles in their Amazon Resource Name (ARN) format.

The maximum number of IAM roles that you can associate is subject to a
quota. For more information, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html}{Quotas and limits}
in the \emph{Amazon Redshift Cluster Management Guide}.}

\item{MaintenanceTrackName}{The name of the maintenance track for the restored cluster. When you
take a snapshot, the snapshot inherits the \code{MaintenanceTrack} value from
the cluster. The snapshot might be on a different track than the cluster
that was the source for the snapshot. For example, suppose that you take
a snapshot of a cluster that is on the current track and then change the
cluster to be on the trailing track. In this case, the snapshot and the
source cluster are on different tracks.}

\item{SnapshotScheduleIdentifier}{A unique identifier for the snapshot schedule.}

\item{NumberOfNodes}{The number of nodes specified when provisioning the restored cluster.}

\item{AvailabilityZoneRelocation}{The option to enable relocation for an Amazon Redshift cluster between
Availability Zones after the cluster is restored.}

\item{AquaConfigurationStatus}{This parameter is retired. It does not set the AQUA configuration
status. Amazon Redshift automatically determines whether to use AQUA
(Advanced Query Accelerator).}

\item{DefaultIamRoleArn}{The Amazon Resource Name (ARN) for the IAM role that was set as default
for the cluster when the cluster was last modified while it was restored
from a snapshot.}

\item{ReservedNodeId}{The identifier of the target reserved node offering.}

\item{TargetReservedNodeOfferingId}{The identifier of the target reserved node offering.}

\item{Encrypted}{Enables support for restoring an unencrypted snapshot to a cluster
encrypted with Key Management Service (KMS) and a customer managed key.}

\item{ManageMasterPassword}{If \code{true}, Amazon Redshift uses Secrets Manager to manage the restored
cluster's admin credentials. If \code{ManageMasterPassword} is false or not
set, Amazon Redshift uses the admin credentials the cluster had at the
time the snapshot was taken.}

\item{MasterPasswordSecretKmsKeyId}{The ID of the Key Management Service (KMS) key used to encrypt and store
the cluster's admin credentials secret. You can only use this parameter
if \code{ManageMasterPassword} is true.}

\item{IpAddressType}{The IP address type for the cluster. Possible values are \code{ipv4} and
\code{dualstack}.}

\item{MultiAZ}{If true, the snapshot will be restored to a cluster deployed in two
Availability Zones.}
}
\description{
Creates a new cluster from a snapshot. By default, Amazon Redshift creates the resulting cluster with the same configuration as the original cluster from which the snapshot was created, except that the new cluster is created with the default cluster security and parameter groups. After Amazon Redshift creates the cluster, you can use the \code{\link[=redshift_modify_cluster]{modify_cluster}} API to associate a different security group and different parameter group with the restored cluster. If you are using a DS node type, you can also choose to change to another DS node type of the same size during restore.

See \url{https://www.paws-r-sdk.com/docs/redshift_restore_from_cluster_snapshot/} for full documentation.
}
\keyword{internal}
