% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_clusters}
\alias{redshift_describe_clusters}
\title{Returns properties of provisioned clusters including general cluster
properties, cluster database properties, maintenance and backup
properties, and security and access properties}
\usage{
redshift_describe_clusters(
  ClusterIdentifier = NULL,
  MaxRecords = NULL,
  Marker = NULL,
  TagKeys = NULL,
  TagValues = NULL
)
}
\arguments{
\item{ClusterIdentifier}{The unique identifier of a cluster whose properties you are requesting.
This parameter is case sensitive.

The default is that all clusters defined for an account are returned.}

\item{MaxRecords}{The maximum number of response records to return in each call. If the
number of remaining response records exceeds the specified \code{MaxRecords}
value, a value is returned in a \code{marker} field of the response. You can
retrieve the next set of records by retrying the command with the
returned marker value.

Default: \code{100}

Constraints: minimum 20, maximum 100.}

\item{Marker}{An optional parameter that specifies the starting point to return a set
of response records. When the results of a
\code{\link[=redshift_describe_clusters]{describe_clusters}} request exceed the
value specified in \code{MaxRecords}, Amazon Web Services returns a value in
the \code{Marker} field of the response. You can retrieve the next set of
response records by providing the returned marker value in the \code{Marker}
parameter and retrying the request.

Constraints: You can specify either the \strong{ClusterIdentifier} parameter
or the \strong{Marker} parameter, but not both.}

\item{TagKeys}{A tag key or keys for which you want to return all matching clusters
that are associated with the specified key or keys. For example, suppose
that you have clusters that are tagged with keys called \code{owner} and
\code{environment}. If you specify both of these tag keys in the request,
Amazon Redshift returns a response with the clusters that have either or
both of these tag keys associated with them.}

\item{TagValues}{A tag value or values for which you want to return all matching clusters
that are associated with the specified tag value or values. For example,
suppose that you have clusters that are tagged with values called
\code{admin} and \code{test}. If you specify both of these tag values in the
request, Amazon Redshift returns a response with the clusters that have
either or both of these tag values associated with them.}
}
\description{
Returns properties of provisioned clusters including general cluster properties, cluster database properties, maintenance and backup properties, and security and access properties. This operation supports pagination. For more information about managing clusters, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html}{Amazon Redshift Clusters} in the \emph{Amazon Redshift Cluster Management Guide}.

See \url{https://www.paws-r-sdk.com/docs/redshift_describe_clusters/} for full documentation.
}
\keyword{internal}
