% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_create_cache_cluster}
\alias{elasticache_create_cache_cluster}
\title{Creates a cluster}
\usage{
elasticache_create_cache_cluster(
  CacheClusterId,
  ReplicationGroupId = NULL,
  AZMode = NULL,
  PreferredAvailabilityZone = NULL,
  PreferredAvailabilityZones = NULL,
  NumCacheNodes = NULL,
  CacheNodeType = NULL,
  Engine = NULL,
  EngineVersion = NULL,
  CacheParameterGroupName = NULL,
  CacheSubnetGroupName = NULL,
  CacheSecurityGroupNames = NULL,
  SecurityGroupIds = NULL,
  Tags = NULL,
  SnapshotArns = NULL,
  SnapshotName = NULL,
  PreferredMaintenanceWindow = NULL,
  Port = NULL,
  NotificationTopicArn = NULL,
  AutoMinorVersionUpgrade = NULL,
  SnapshotRetentionLimit = NULL,
  SnapshotWindow = NULL,
  AuthToken = NULL,
  OutpostMode = NULL,
  PreferredOutpostArn = NULL,
  PreferredOutpostArns = NULL,
  LogDeliveryConfigurations = NULL,
  TransitEncryptionEnabled = NULL,
  NetworkType = NULL,
  IpDiscovery = NULL
)
}
\arguments{
\item{CacheClusterId}{[required] The node group (shard) identifier. This parameter is stored as a
lowercase string.

\strong{Constraints:}
\itemize{
\item A name must contain from 1 to 50 alphanumeric characters or hyphens.
\item The first character must be a letter.
\item A name cannot end with a hyphen or contain two consecutive hyphens.
}}

\item{ReplicationGroupId}{The ID of the replication group to which this cluster should belong. If
this parameter is specified, the cluster is added to the specified
replication group as a read replica; otherwise, the cluster is a
standalone primary that is not part of any replication group.

If the specified replication group is Multi-AZ enabled and the
Availability Zone is not specified, the cluster is created in
Availability Zones that provide the best spread of read replicas across
Availability Zones.

This parameter is only valid if the \code{Engine} parameter is \code{redis}.}

\item{AZMode}{Specifies whether the nodes in this Memcached cluster are created in a
single Availability Zone or created across multiple Availability Zones
in the cluster's region.

This parameter is only supported for Memcached clusters.

If the \code{AZMode} and \code{PreferredAvailabilityZones} are not specified,
ElastiCache assumes \code{single-az} mode.}

\item{PreferredAvailabilityZone}{The EC2 Availability Zone in which the cluster is created.

All nodes belonging to this cluster are placed in the preferred
Availability Zone. If you want to create your nodes across multiple
Availability Zones, use \code{PreferredAvailabilityZones}.

Default: System chosen Availability Zone.}

\item{PreferredAvailabilityZones}{A list of the Availability Zones in which cache nodes are created. The
order of the zones in the list is not important.

This option is only supported on Memcached.

If you are creating your cluster in an Amazon VPC (recommended) you can
only locate nodes in Availability Zones that are associated with the
subnets in the selected subnet group.

The number of Availability Zones listed must equal the value of
\code{NumCacheNodes}.

If you want all the nodes in the same Availability Zone, use
\code{PreferredAvailabilityZone} instead, or repeat the Availability Zone
multiple times in the list.

Default: System chosen Availability Zones.}

\item{NumCacheNodes}{The initial number of cache nodes that the cluster has.

For clusters running Redis, this value must be 1. For clusters running
Memcached, this value must be between 1 and 40.

If you need more than 40 nodes for your Memcached cluster, please fill
out the ElastiCache Limit Increase Request form at
http://aws.amazon.com/contact-us/elasticache-node-limit-request/.}

\item{CacheNodeType}{The compute and memory capacity of the nodes in the node group (shard).

The following node types are supported by ElastiCache. Generally
speaking, the current generation types provide more memory and
computational power at lower cost when compared to their equivalent
previous generation counterparts.
\itemize{
\item General purpose:
\itemize{
\item Current generation:

\strong{M6g node types} (available only for Redis engine version
5.0.6 onward and for Memcached engine version 1.5.16 onward):
\code{cache.m6g.large}, \code{cache.m6g.xlarge}, \code{cache.m6g.2xlarge},
\code{cache.m6g.4xlarge}, \code{cache.m6g.8xlarge}, \code{cache.m6g.12xlarge},
\code{cache.m6g.16xlarge}

For region availability, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion}{Supported Node Types}

\strong{M5 node types:} \code{cache.m5.large}, \code{cache.m5.xlarge},
\code{cache.m5.2xlarge}, \code{cache.m5.4xlarge}, \code{cache.m5.12xlarge},
\code{cache.m5.24xlarge}

\strong{M4 node types:} \code{cache.m4.large}, \code{cache.m4.xlarge},
\code{cache.m4.2xlarge}, \code{cache.m4.4xlarge}, \code{cache.m4.10xlarge}

\strong{T4g node types} (available only for Redis engine version
5.0.6 onward and Memcached engine version 1.5.16 onward):
\code{cache.t4g.micro}, \code{cache.t4g.small}, \code{cache.t4g.medium}

\strong{T3 node types:} \code{cache.t3.micro}, \code{cache.t3.small},
\code{cache.t3.medium}

\strong{T2 node types:} \code{cache.t2.micro}, \code{cache.t2.small},
\code{cache.t2.medium}
\item Previous generation: (not recommended. Existing clusters are
still supported but creation of new clusters is not supported
for these types.)

\strong{T1 node types:} \code{cache.t1.micro}

\strong{M1 node types:} \code{cache.m1.small}, \code{cache.m1.medium},
\code{cache.m1.large}, \code{cache.m1.xlarge}

\strong{M3 node types:} \code{cache.m3.medium}, \code{cache.m3.large},
\code{cache.m3.xlarge}, \code{cache.m3.2xlarge}
}
\item Compute optimized:
\itemize{
\item Previous generation: (not recommended. Existing clusters are
still supported but creation of new clusters is not supported
for these types.)

\strong{C1 node types:} \code{cache.c1.xlarge}
}
\item Memory optimized:
\itemize{
\item Current generation:

\strong{R6g node types} (available only for Redis engine version
5.0.6 onward and for Memcached engine version 1.5.16 onward).

\code{cache.r6g.large}, \code{cache.r6g.xlarge}, \code{cache.r6g.2xlarge},
\code{cache.r6g.4xlarge}, \code{cache.r6g.8xlarge}, \code{cache.r6g.12xlarge},
\code{cache.r6g.16xlarge}

For region availability, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion}{Supported Node Types}

\strong{R5 node types:} \code{cache.r5.large}, \code{cache.r5.xlarge},
\code{cache.r5.2xlarge}, \code{cache.r5.4xlarge}, \code{cache.r5.12xlarge},
\code{cache.r5.24xlarge}

\strong{R4 node types:} \code{cache.r4.large}, \code{cache.r4.xlarge},
\code{cache.r4.2xlarge}, \code{cache.r4.4xlarge}, \code{cache.r4.8xlarge},
\code{cache.r4.16xlarge}
\item Previous generation: (not recommended. Existing clusters are
still supported but creation of new clusters is not supported
for these types.)

\strong{M2 node types:} \code{cache.m2.xlarge}, \code{cache.m2.2xlarge},
\code{cache.m2.4xlarge}

\strong{R3 node types:} \code{cache.r3.large}, \code{cache.r3.xlarge},
\code{cache.r3.2xlarge}, \code{cache.r3.4xlarge}, \code{cache.r3.8xlarge}
}
}

\strong{Additional node type info}
\itemize{
\item All current generation instance types are created in Amazon VPC by
default.
\item Redis append-only files (AOF) are not supported for T1 or T2
instances.
\item Redis Multi-AZ with automatic failover is not supported on T1
instances.
\item Redis configuration variables \code{appendonly} and \code{appendfsync} are not
supported on Redis version 2.8.22 and later.
}}

\item{Engine}{The name of the cache engine to be used for this cluster.

Valid values for this parameter are: \code{memcached} | \code{redis}}

\item{EngineVersion}{The version number of the cache engine to be used for this cluster. To
view the supported cache engine versions, use the
DescribeCacheEngineVersions operation.

\strong{Important:} You can upgrade to a newer engine version (see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement}{Selecting a Cache Engine and Version}),
but you cannot downgrade to an earlier engine version. If you want to
use an earlier engine version, you must delete the existing cluster or
replication group and create it anew with the earlier engine version.}

\item{CacheParameterGroupName}{The name of the parameter group to associate with this cluster. If this
argument is omitted, the default parameter group for the specified
engine is used. You cannot use any parameter group which has
\code{cluster-enabled='yes'} when creating a cluster.}

\item{CacheSubnetGroupName}{The name of the subnet group to be used for the cluster.

Use this parameter only when you are creating a cluster in an Amazon
Virtual Private Cloud (Amazon VPC).

If you're going to launch your cluster in an Amazon VPC, you need to
create a subnet group before you start creating a cluster. For more
information, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html}{Subnets and Subnet Groups}.}

\item{CacheSecurityGroupNames}{A list of security group names to associate with this cluster.

Use this parameter only when you are creating a cluster outside of an
Amazon Virtual Private Cloud (Amazon VPC).}

\item{SecurityGroupIds}{One or more VPC security groups associated with the cluster.

Use this parameter only when you are creating a cluster in an Amazon
Virtual Private Cloud (Amazon VPC).}

\item{Tags}{A list of tags to be added to this resource.}

\item{SnapshotArns}{A single-element string list containing an Amazon Resource Name (ARN)
that uniquely identifies a Redis RDB snapshot file stored in Amazon S3.
The snapshot file is used to populate the node group (shard). The Amazon
S3 object name in the ARN cannot contain any commas.

This parameter is only valid if the \code{Engine} parameter is \code{redis}.

Example of an Amazon S3 ARN: \code{arn:aws:s3:::my_bucket/snapshot1.rdb}}

\item{SnapshotName}{The name of a Redis snapshot from which to restore data into the new
node group (shard). The snapshot status changes to \code{restoring} while the
new node group (shard) is being created.

This parameter is only valid if the \code{Engine} parameter is \code{redis}.}

\item{PreferredMaintenanceWindow}{Specifies the weekly time range during which maintenance on the cluster
is performed. It is specified as a range in the format
ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
is a 60 minute period.}

\item{Port}{The port number on which each of the cache nodes accepts connections.}

\item{NotificationTopicArn}{The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
(SNS) topic to which notifications are sent.

The Amazon SNS topic owner must be the same as the cluster owner.}

\item{AutoMinorVersionUpgrade}{If you are running Redis engine version 6.0 or later, set this
parameter to yes if you want to opt-in to the next auto minor version
upgrade campaign. This parameter is disabled for previous versions.}

\item{SnapshotRetentionLimit}{The number of days for which ElastiCache retains automatic snapshots
before deleting them. For example, if you set \code{SnapshotRetentionLimit}
to 5, a snapshot taken today is retained for 5 days before being
deleted.

This parameter is only valid if the \code{Engine} parameter is \code{redis}.

Default: 0 (i.e., automatic backups are disabled for this cache
cluster).}

\item{SnapshotWindow}{The daily time range (in UTC) during which ElastiCache begins taking a
daily snapshot of your node group (shard).

Example: \code{05:00-09:00}

If you do not specify this parameter, ElastiCache automatically chooses
an appropriate time range.

This parameter is only valid if the \code{Engine} parameter is \code{redis}.}

\item{AuthToken}{\strong{Reserved parameter.} The password used to access a password protected
server.

Password constraints:
\itemize{
\item Must be only printable ASCII characters.
\item Must be at least 16 characters and no more than 128 characters in
length.
\item The only permitted printable special characters are !, &, #, $, ^,
\<, \>, and -. Other printable special characters cannot be used in
the AUTH token.
}

For more information, see \href{https://redis.io/commands/auth/}{AUTH password} at
http://redis.io/commands/AUTH.}

\item{OutpostMode}{Specifies whether the nodes in the cluster are created in a single
outpost or across multiple outposts.}

\item{PreferredOutpostArn}{The outpost ARN in which the cache cluster is created.}

\item{PreferredOutpostArns}{The outpost ARNs in which the cache cluster is created.}

\item{LogDeliveryConfigurations}{Specifies the destination, format and type of the logs.}

\item{TransitEncryptionEnabled}{A flag that enables in-transit encryption when set to true.}

\item{NetworkType}{Must be either \code{ipv4} | \code{ipv6} | \code{dual_stack}. IPv6 is supported for
workloads using Redis engine version 6.2 onward or Memcached engine
version 1.6.6 on all instances built on the \href{https://aws.amazon.com/ec2/nitro/}{Nitro system}.}

\item{IpDiscovery}{The network type you choose when modifying a cluster, either \code{ipv4} |
\code{ipv6}. IPv6 is supported for workloads using Redis engine version 6.2
onward or Memcached engine version 1.6.6 on all instances built on the
\href{https://aws.amazon.com/ec2/nitro/}{Nitro system}.}
}
\description{
Creates a cluster. All nodes in the cluster run the same protocol-compliant cache engine software, either Memcached or Redis.

See \url{https://www.paws-r-sdk.com/docs/elasticache_create_cache_cluster/} for full documentation.
}
\keyword{internal}
