% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshiftserverless_operations.R
\name{redshiftserverless_create_endpoint_access}
\alias{redshiftserverless_create_endpoint_access}
\title{Creates an Amazon Redshift Serverless managed VPC endpoint}
\usage{
redshiftserverless_create_endpoint_access(
  endpointName,
  subnetIds,
  vpcSecurityGroupIds = NULL,
  workgroupName
)
}
\arguments{
\item{endpointName}{[required] The name of the VPC endpoint. An endpoint name must contain 1-30
characters. Valid characters are A-Z, a-z, 0-9, and hyphen(-). The first
character must be a letter. The name can't contain two consecutive
hyphens or end with a hyphen.}

\item{subnetIds}{[required] The unique identifers of subnets from which Amazon Redshift Serverless
chooses one to deploy a VPC endpoint.}

\item{vpcSecurityGroupIds}{The unique identifiers of the security group that defines the ports,
protocols, and sources for inbound traffic that you are authorizing into
your endpoint.}

\item{workgroupName}{[required] The name of the workgroup to associate with the VPC endpoint.}
}
\description{
Creates an Amazon Redshift Serverless managed VPC endpoint.

See \url{https://www.paws-r-sdk.com/docs/redshiftserverless_create_endpoint_access/} for full documentation.
}
\keyword{internal}
