% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_create_usage_limit}
\alias{redshift_create_usage_limit}
\title{Creates a usage limit for a specified Amazon Redshift feature on a
cluster}
\usage{
redshift_create_usage_limit(
  ClusterIdentifier,
  FeatureType,
  LimitType,
  Amount,
  Period = NULL,
  BreachAction = NULL,
  Tags = NULL
)
}
\arguments{
\item{ClusterIdentifier}{[required] The identifier of the cluster that you want to limit usage.}

\item{FeatureType}{[required] The Amazon Redshift feature that you want to limit.}

\item{LimitType}{[required] The type of limit. Depending on the feature type, this can be based on a
time duration or data size. If \code{FeatureType} is \code{spectrum}, then
\code{LimitType} must be \code{data-scanned}. If \code{FeatureType} is
\code{concurrency-scaling}, then \code{LimitType} must be \code{time}. If \code{FeatureType}
is \code{cross-region-datasharing}, then \code{LimitType} must be \code{data-scanned}.}

\item{Amount}{[required] The limit amount. If time-based, this amount is in minutes. If
data-based, this amount is in terabytes (TB). The value must be a
positive number.}

\item{Period}{The time period that the amount applies to. A \code{weekly} period begins on
Sunday. The default is \code{monthly}.}

\item{BreachAction}{The action that Amazon Redshift takes when the limit is reached. The
default is log. For more information about this parameter, see
UsageLimit.}

\item{Tags}{A list of tag instances.}
}
\description{
Creates a usage limit for a specified Amazon Redshift feature on a cluster. The usage limit is identified by the returned usage limit identifier.

See \url{https://www.paws-r-sdk.com/docs/redshift_create_usage_limit/} for full documentation.
}
\keyword{internal}
