% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_global_cluster}
\alias{rds_create_global_cluster}
\title{Creates an Aurora global database spread across multiple Amazon Web
Services Regions}
\usage{
rds_create_global_cluster(
  GlobalClusterIdentifier = NULL,
  SourceDBClusterIdentifier = NULL,
  Engine = NULL,
  EngineVersion = NULL,
  DeletionProtection = NULL,
  DatabaseName = NULL,
  StorageEncrypted = NULL
)
}
\arguments{
\item{GlobalClusterIdentifier}{The cluster identifier of the new global database cluster. This
parameter is stored as a lowercase string.}

\item{SourceDBClusterIdentifier}{The Amazon Resource Name (ARN) to use as the primary cluster of the
global database. This parameter is optional.}

\item{Engine}{The name of the database engine to be used for this DB cluster.}

\item{EngineVersion}{The engine version of the Aurora global database.}

\item{DeletionProtection}{The deletion protection setting for the new global database. The global
database can't be deleted when deletion protection is enabled.}

\item{DatabaseName}{The name for your database of up to 64 alphanumeric characters. If you
do not provide a name, Amazon Aurora will not create a database in the
global database cluster you are creating.}

\item{StorageEncrypted}{The storage encryption setting for the new global database cluster.}
}
\description{
Creates an Aurora global database spread across multiple Amazon Web Services Regions. The global database contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.

See \url{https://www.paws-r-sdk.com/docs/rds_create_global_cluster/} for full documentation.
}
\keyword{internal}
