% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_delete_db_instance}
\alias{neptune_delete_db_instance}
\title{The DeleteDBInstance action deletes a previously provisioned DB instance}
\usage{
neptune_delete_db_instance(
  DBInstanceIdentifier,
  SkipFinalSnapshot = NULL,
  FinalDBSnapshotIdentifier = NULL
)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The DB instance identifier for the DB instance to be deleted. This
parameter isn't case-sensitive.

Constraints:
\itemize{
\item Must match the name of an existing DB instance.
}}

\item{SkipFinalSnapshot}{Determines whether a final DB snapshot is created before the DB instance
is deleted. If \code{true} is specified, no DBSnapshot is created. If \code{false}
is specified, a DB snapshot is created before the DB instance is
deleted.

Note that when a DB instance is in a failure state and has a status of
'failed', 'incompatible-restore', or 'incompatible-network', it can only
be deleted when the SkipFinalSnapshot parameter is set to "true".

Specify \code{true} when deleting a Read Replica.

The FinalDBSnapshotIdentifier parameter must be specified if
SkipFinalSnapshot is \code{false}.

Default: \code{false}}

\item{FinalDBSnapshotIdentifier}{The DBSnapshotIdentifier of the new DBSnapshot created when
SkipFinalSnapshot is set to \code{false}.

Specifying this parameter and also setting the SkipFinalShapshot
parameter to true results in an error.

Constraints:
\itemize{
\item Must be 1 to 255 letters or numbers.
\item First character must be a letter
\item Cannot end with a hyphen or contain two consecutive hyphens
\item Cannot be specified when deleting a Read Replica.
}}
}
\description{
The DeleteDBInstance action deletes a previously provisioned DB instance. When you delete a DB instance, all automated backups for that instance are deleted and can't be recovered. Manual DB snapshots of the DB instance to be deleted by \code{\link[=neptune_delete_db_instance]{delete_db_instance}} are not deleted.

See \url{https://www.paws-r-sdk.com/docs/neptune_delete_db_instance/} for full documentation.
}
\keyword{internal}
