% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_update_contributor_insights}
\alias{dynamodb_update_contributor_insights}
\title{Updates the status for contributor insights for a specific table or
index}
\usage{
dynamodb_update_contributor_insights(
  TableName,
  IndexName = NULL,
  ContributorInsightsAction
)
}
\arguments{
\item{TableName}{[required] The name of the table.}

\item{IndexName}{The global secondary index name, if applicable.}

\item{ContributorInsightsAction}{[required] Represents the contributor insights action.}
}
\description{
Updates the status for contributor insights for a specific table or index. CloudWatch Contributor Insights for DynamoDB graphs display the partition key and (if applicable) sort key of frequently accessed items and frequently throttled items in plaintext. If you require the use of Amazon Web Services Key Management Service (KMS) to encrypt this table’s partition key and sort key data with an Amazon Web Services managed key or customer managed key, you should not enable CloudWatch Contributor Insights for DynamoDB for this table.

See \url{https://www.paws-r-sdk.com/docs/dynamodb_update_contributor_insights/} for full documentation.
}
\keyword{internal}
