% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_execute_statement}
\alias{dynamodb_execute_statement}
\title{This operation allows you to perform reads and singleton writes on data
stored in DynamoDB, using PartiQL}
\usage{
dynamodb_execute_statement(
  Statement,
  Parameters = NULL,
  ConsistentRead = NULL,
  NextToken = NULL,
  ReturnConsumedCapacity = NULL,
  Limit = NULL
)
}
\arguments{
\item{Statement}{[required] The PartiQL statement representing the operation to run.}

\item{Parameters}{The parameters for the PartiQL statement, if any.}

\item{ConsistentRead}{The consistency of a read operation. If set to \code{true}, then a strongly
consistent read is used; otherwise, an eventually consistent read is
used.}

\item{NextToken}{Set this value to get remaining results, if \code{NextToken} was returned in
the statement response.}

\item{ReturnConsumedCapacity}{}

\item{Limit}{The maximum number of items to evaluate (not necessarily the number of
matching items). If DynamoDB processes the number of items up to the
limit while processing the results, it stops the operation and returns
the matching values up to that point, along with a key in
\code{LastEvaluatedKey} to apply in a subsequent operation so you can pick up
where you left off. Also, if the processed dataset size exceeds 1 MB
before DynamoDB reaches this limit, it stops the operation and returns
the matching values up to the limit, and a key in \code{LastEvaluatedKey} to
apply in a subsequent operation to continue the operation.}
}
\description{
This operation allows you to perform reads and singleton writes on data stored in DynamoDB, using PartiQL.

See \url{https://www.paws-r-sdk.com/docs/dynamodb_execute_statement/} for full documentation.
}
\keyword{internal}
