% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_orderable_cluster_options}
\alias{redshift_describe_orderable_cluster_options}
\title{Returns a list of orderable cluster options}
\usage{
redshift_describe_orderable_cluster_options(
  ClusterVersion = NULL,
  NodeType = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{ClusterVersion}{The version filter value. Specify this parameter to show only the
available offerings matching the specified version.

Default: All versions.

Constraints: Must be one of the version returned from
\code{\link[=redshift_describe_cluster_versions]{describe_cluster_versions}}.}

\item{NodeType}{The node type filter value. Specify this parameter to show only the
available offerings matching the specified node type.}

\item{MaxRecords}{The maximum number of response records to return in each call. If the
number of remaining response records exceeds the specified \code{MaxRecords}
value, a value is returned in a \code{marker} field of the response. You can
retrieve the next set of records by retrying the command with the
returned marker value.

Default: \code{100}

Constraints: minimum 20, maximum 100.}

\item{Marker}{An optional parameter that specifies the starting point to return a set
of response records. When the results of a
\code{\link[=redshift_describe_orderable_cluster_options]{describe_orderable_cluster_options}}
request exceed the value specified in \code{MaxRecords}, Amazon Web Services
returns a value in the \code{Marker} field of the response. You can retrieve
the next set of response records by providing the returned marker value
in the \code{Marker} parameter and retrying the request.}
}
\description{
Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find what options are available, such as the EC2 Availability Zones (AZ) in the specific Amazon Web Services Region that you can specify, and the node types you can request. The node types differ by available storage, memory, CPU and price. With the cost involved you might want to obtain a list of cluster options in the specific region and specify values when creating a cluster. For more information about managing clusters, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html}{Amazon Redshift Clusters} in the \emph{Amazon Redshift Cluster Management Guide}.

See \url{https://paws-r.github.io/docs/redshift/describe_orderable_cluster_options.html} for full documentation.
}
\keyword{internal}
