% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qldb_operations.R
\name{qldb_stream_journal_to_kinesis}
\alias{qldb_stream_journal_to_kinesis}
\title{Creates a journal stream for a given Amazon QLDB ledger}
\usage{
qldb_stream_journal_to_kinesis(
  LedgerName,
  RoleArn,
  Tags = NULL,
  InclusiveStartTime,
  ExclusiveEndTime = NULL,
  KinesisConfiguration,
  StreamName
)
}
\arguments{
\item{LedgerName}{[required] The name of the ledger.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role that grants QLDB
permissions for a journal stream to write data records to a Kinesis Data
Streams resource.

To pass a role to QLDB when requesting a journal stream, you must have
permissions to perform the \code{iam:PassRole} action on the IAM role
resource. This is required for all journal stream requests.}

\item{Tags}{The key-value pairs to add as tags to the stream that you want to
create. Tag keys are case sensitive. Tag values are case sensitive and
can be null.}

\item{InclusiveStartTime}{[required] The inclusive start date and time from which to start streaming journal
data. This parameter must be in \verb{ISO 8601} date and time format and in
Universal Coordinated Time (UTC). For example: \verb{2019-06-13T21:36:34Z}.

The \code{InclusiveStartTime} cannot be in the future and must be before
\code{ExclusiveEndTime}.

If you provide an \code{InclusiveStartTime} that is before the ledger's
\code{CreationDateTime}, QLDB effectively defaults it to the ledger's
\code{CreationDateTime}.}

\item{ExclusiveEndTime}{The exclusive date and time that specifies when the stream ends. If you
don't define this parameter, the stream runs indefinitely until you
cancel it.

The \code{ExclusiveEndTime} must be in \verb{ISO 8601} date and time format and in
Universal Coordinated Time (UTC). For example: \verb{2019-06-13T21:36:34Z}.}

\item{KinesisConfiguration}{[required] The configuration settings of the Kinesis Data Streams destination for
your stream request.}

\item{StreamName}{[required] The name that you want to assign to the QLDB journal stream.
User-defined names can help identify and indicate the purpose of a
stream.

Your stream name must be unique among other \emph{active} streams for a given
ledger. Stream names have the same naming constraints as ledger names,
as defined in \href{https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming}{Quotas in Amazon QLDB}
in the \emph{Amazon QLDB Developer Guide}.}
}
\description{
Creates a journal stream for a given Amazon QLDB ledger. The stream captures every document revision that is committed to the ledger's journal and delivers the data to a specified Amazon Kinesis Data Streams resource.

See \url{https://paws-r.github.io/docs/qldb/stream_journal_to_kinesis.html} for full documentation.
}
\keyword{internal}
