% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_create_backup}
\alias{dynamodb_create_backup}
\title{Creates a backup for an existing table}
\usage{
dynamodb_create_backup(TableName, BackupName)
}
\arguments{
\item{TableName}{[required] The name of the table.}

\item{BackupName}{[required] Specified name for the backup.}
}
\description{
Creates a backup for an existing table.
}
\details{
Each time you create an on-demand backup, the entire table data is
backed up. There is no limit to the number of on-demand backups that can
be taken.

When you create an on-demand backup, a time marker of the request is
cataloged, and the backup is created asynchronously, by applying all
changes until the time of the request to the last full table snapshot.
Backup requests are processed instantaneously and become available for
restore within minutes.

You can call \code{CreateBackup} at a maximum rate of 50 times per second.

All backups in DynamoDB work without consuming any provisioned
throughput on the table.

If you submit a backup request on 2018-12-14 at 14:25:00, the backup is
guaranteed to contain all data committed to the table up to 14:24:00,
and data committed after 14:26:00 will not be. The backup might contain
data modifications made between 14:24:00 and 14:26:00. On-demand backup
does not support causal consistency.

Along with data, the following are also included on the backups:
\itemize{
\item Global secondary indexes (GSIs)
\item Local secondary indexes (LSIs)
\item Streams
\item Provisioned read and write capacity
}
}
\section{Request syntax}{
\preformatted{svc$create_backup(
  TableName = "string",
  BackupName = "string"
)
}
}

\keyword{internal}
