% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_delete_db_cluster}
\alias{rds_delete_db_cluster}
\title{The DeleteDBCluster action deletes a previously provisioned DB cluster}
\usage{
rds_delete_db_cluster(DBClusterIdentifier, SkipFinalSnapshot,
  FinalDBSnapshotIdentifier)
}
\arguments{
\item{DBClusterIdentifier}{[required] The DB cluster identifier for the DB cluster to be deleted. This
parameter isn't case-sensitive.

Constraints:
\itemize{
\item Must match an existing DBClusterIdentifier.
}}

\item{SkipFinalSnapshot}{A value that indicates whether to skip the creation of a final DB
cluster snapshot before the DB cluster is deleted. If skip is specified,
no DB cluster snapshot is created. If skip isn't specified, a DB cluster
snapshot is created before the DB cluster is deleted. By default, skip
isn't specified, and the DB cluster snapshot is created. By default,
this parameter is disabled.

You must specify a \code{FinalDBSnapshotIdentifier} parameter if
\code{SkipFinalSnapshot} is disabled.}

\item{FinalDBSnapshotIdentifier}{The DB cluster snapshot identifier of the new DB cluster snapshot
created when \code{SkipFinalSnapshot} is disabled.

Specifying this parameter and also skipping the creation of a final DB
cluster snapshot with the \code{SkipFinalShapshot} parameter results in an
error.

Constraints:
\itemize{
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}}
}
\value{
A list with the following syntax:\preformatted{list(
  DBCluster = list(
    AllocatedStorage = 123,
    AvailabilityZones = list(
      "string"
    ),
    BackupRetentionPeriod = 123,
    CharacterSetName = "string",
    DatabaseName = "string",
    DBClusterIdentifier = "string",
    DBClusterParameterGroup = "string",
    DBSubnetGroup = "string",
    Status = "string",
    PercentProgress = "string",
    EarliestRestorableTime = as.POSIXct(
      "2015-01-01"
    ),
    Endpoint = "string",
    ReaderEndpoint = "string",
    CustomEndpoints = list(
      "string"
    ),
    MultiAZ = TRUE|FALSE,
    Engine = "string",
    EngineVersion = "string",
    LatestRestorableTime = as.POSIXct(
      "2015-01-01"
    ),
    Port = 123,
    MasterUsername = "string",
    DBClusterOptionGroupMemberships = list(
      list(
        DBClusterOptionGroupName = "string",
        Status = "string"
      )
    ),
    PreferredBackupWindow = "string",
    PreferredMaintenanceWindow = "string",
    ReplicationSourceIdentifier = "string",
    ReadReplicaIdentifiers = list(
      "string"
    ),
    DBClusterMembers = list(
      list(
        DBInstanceIdentifier = "string",
        IsClusterWriter = TRUE|FALSE,
        DBClusterParameterGroupStatus = "string",
        PromotionTier = 123
      )
    ),
    VpcSecurityGroups = list(
      list(
        VpcSecurityGroupId = "string",
        Status = "string"
      )
    ),
    HostedZoneId = "string",
    StorageEncrypted = TRUE|FALSE,
    KmsKeyId = "string",
    DbClusterResourceId = "string",
    DBClusterArn = "string",
    AssociatedRoles = list(
      list(
        RoleArn = "string",
        Status = "string",
        FeatureName = "string"
      )
    ),
    IAMDatabaseAuthenticationEnabled = TRUE|FALSE,
    CloneGroupId = "string",
    ClusterCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    EarliestBacktrackTime = as.POSIXct(
      "2015-01-01"
    ),
    BacktrackWindow = 123,
    BacktrackConsumedChangeRecords = 123,
    EnabledCloudwatchLogsExports = list(
      "string"
    ),
    Capacity = 123,
    EngineMode = "string",
    ScalingConfigurationInfo = list(
      MinCapacity = 123,
      MaxCapacity = 123,
      AutoPause = TRUE|FALSE,
      SecondsUntilAutoPause = 123,
      TimeoutAction = "string"
    ),
    DeletionProtection = TRUE|FALSE,
    HttpEndpointEnabled = TRUE|FALSE,
    ActivityStreamMode = "sync"|"async",
    ActivityStreamStatus = "stopped"|"starting"|"started"|"stopping",
    ActivityStreamKmsKeyId = "string",
    ActivityStreamKinesisStreamName = "string",
    CopyTagsToSnapshot = TRUE|FALSE,
    CrossAccountClone = TRUE|FALSE,
    DomainMemberships = list(
      list(
        Domain = "string",
        Status = "string",
        FQDN = "string",
        IAMRoleName = "string"
      )
    ),
    TagList = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    GlobalWriteForwardingStatus = "enabled"|"disabled"|"enabling"|"disabling"|"unknown",
    GlobalWriteForwardingRequested = TRUE|FALSE,
    PendingModifiedValues = list(
      PendingCloudwatchLogsExports = list(
        LogTypesToEnable = list(
          "string"
        ),
        LogTypesToDisable = list(
          "string"
        )
      ),
      DBClusterIdentifier = "string",
      MasterUserPassword = "string",
      IAMDatabaseAuthenticationEnabled = TRUE|FALSE,
      EngineVersion = "string"
    )
  )
)
}
}
\description{
The DeleteDBCluster action deletes a previously provisioned DB cluster.
When you delete a DB cluster, all automated backups for that DB cluster
are deleted and can't be recovered. Manual DB cluster snapshots of the
specified DB cluster are not deleted.

For more information on Amazon Aurora, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html}{What Is Amazon Aurora?}
in the \emph{Amazon Aurora User Guide.}

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$delete_db_cluster(
  DBClusterIdentifier = "string",
  SkipFinalSnapshot = TRUE|FALSE,
  FinalDBSnapshotIdentifier = "string"
)
}
}

\keyword{internal}
