% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_reset_db_parameter_group}
\alias{neptune_reset_db_parameter_group}
\title{Modifies the parameters of a DB parameter group to the engine/system
default value}
\usage{
neptune_reset_db_parameter_group(DBParameterGroupName,
  ResetAllParameters, Parameters)
}
\arguments{
\item{DBParameterGroupName}{[required] The name of the DB parameter group.

Constraints:
\itemize{
\item Must match the name of an existing DBParameterGroup.
}}

\item{ResetAllParameters}{Specifies whether (\code{true}) or not (\code{false}) to reset all parameters in
the DB parameter group to default values.

Default: \code{true}}

\item{Parameters}{To reset the entire DB parameter group, specify the \code{DBParameterGroup}
name and \code{ResetAllParameters} parameters. To reset specific parameters,
provide a list of the following: \code{ParameterName} and \code{ApplyMethod}. A
maximum of 20 parameters can be modified in a single request.

Valid Values (for Apply method): \code{pending-reboot}}
}
\value{
A list with the following syntax:\preformatted{list(
  DBParameterGroupName = "string"
)
}
}
\description{
Modifies the parameters of a DB parameter group to the engine/system
default value. To reset specific parameters, provide a list of the
following: \code{ParameterName} and \code{ApplyMethod}. To reset the entire DB
parameter group, specify the \code{DBParameterGroup} name and
\code{ResetAllParameters} parameters. When resetting the entire group,
dynamic parameters are updated immediately and static parameters are set
to \code{pending-reboot} to take effect on the next DB instance restart or
\code{\link[=neptune_reboot_db_instance]{reboot_db_instance}} request.
}
\section{Request syntax}{
\preformatted{svc$reset_db_parameter_group(
  DBParameterGroupName = "string",
  ResetAllParameters = TRUE|FALSE,
  Parameters = list(
    list(
      ParameterName = "string",
      ParameterValue = "string",
      Description = "string",
      Source = "string",
      ApplyType = "string",
      DataType = "string",
      AllowedValues = "string",
      IsModifiable = TRUE|FALSE,
      MinimumEngineVersion = "string",
      ApplyMethod = "immediate"|"pending-reboot"
    )
  )
)
}
}

\keyword{internal}
