% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_update_custom_verification_email_template}
\alias{ses_update_custom_verification_email_template}
\title{Updates an existing custom verification email template}
\usage{
ses_update_custom_verification_email_template(
  TemplateName,
  FromEmailAddress = NULL,
  TemplateSubject = NULL,
  TemplateContent = NULL,
  SuccessRedirectionURL = NULL,
  FailureRedirectionURL = NULL
)
}
\arguments{
\item{TemplateName}{[required] The name of the custom verification email template that you want to
update.}

\item{FromEmailAddress}{The email address that the custom verification email is sent from.}

\item{TemplateSubject}{The subject line of the custom verification email.}

\item{TemplateContent}{The content of the custom verification email. The total size of the
email must be less than 10 MB. The message body may contain HTML, with
some limitations. For more information, see \href{https://docs.aws.amazon.com/ses/latest/dg/Welcome.html#custom-verification-emails-faq}{Custom Verification Email Frequently Asked Questions}
in the \emph{Amazon SES Developer Guide}.}

\item{SuccessRedirectionURL}{The URL that the recipient of the verification email is sent to if his
or her address is successfully verified.}

\item{FailureRedirectionURL}{The URL that the recipient of the verification email is sent to if his
or her address is not successfully verified.}
}
\description{
Updates an existing custom verification email template.

See \url{https://paws-r.github.io/docs/ses/update_custom_verification_email_template.html} for full documentation.
}
\keyword{internal}
