% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_purchase_host_reservation}
\alias{ec2_purchase_host_reservation}
\title{Purchase a reservation with configurations that match those of your
Dedicated Host}
\usage{
ec2_purchase_host_reservation(
  ClientToken = NULL,
  CurrencyCode = NULL,
  HostIdSet,
  LimitPrice = NULL,
  OfferingId,
  TagSpecifications = NULL
)
}
\arguments{
\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring Idempotency}.}

\item{CurrencyCode}{The currency in which the \code{totalUpfrontPrice}, \code{LimitPrice}, and
\code{totalHourlyPrice} amounts are specified. At this time, the only
supported currency is \code{USD}.}

\item{HostIdSet}{[required] The IDs of the Dedicated Hosts with which the reservation will be
associated.}

\item{LimitPrice}{The specified limit is checked against the total upfront cost of the
reservation (calculated as the offering's upfront cost multiplied by the
host count). If the total upfront cost is greater than the specified
price limit, the request fails. This is used to ensure that the purchase
does not exceed the expected upfront cost of the purchase. At this time,
the only supported currency is \code{USD}. For example, to indicate a limit
price of USD 100, specify 100.00.}

\item{OfferingId}{[required] The ID of the offering.}

\item{TagSpecifications}{The tags to apply to the Dedicated Host Reservation during purchase.}
}
\description{
Purchase a reservation with configurations that match those of your Dedicated Host. You must have active Dedicated Hosts in your account before you purchase a reservation. This action results in the specified reservation being purchased and charged to your account.

See \url{https://www.paws-r-sdk.com/docs/ec2_purchase_host_reservation/} for full documentation.
}
\keyword{internal}
