% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_alarms}
\alias{lightsail_get_alarms}
\title{Returns information about the configured alarms}
\usage{
lightsail_get_alarms(
  alarmName = NULL,
  pageToken = NULL,
  monitoredResourceName = NULL
)
}
\arguments{
\item{alarmName}{The name of the alarm.

Specify an alarm name to return information about a specific alarm.}

\item{pageToken}{The token to advance to the next page of results from your request.

To get a page token, perform an initial
\code{\link[=lightsail_get_alarms]{get_alarms}} request. If your results are
paginated, the response will return a next page token that you can
specify as the page token in a subsequent request.}

\item{monitoredResourceName}{The name of the Lightsail resource being monitored by the alarm.

Specify a monitored resource name to return information about all alarms
for a specific resource.}
}
\description{
Returns information about the configured alarms. Specify an alarm name in your request to return information about a specific alarm, or specify a monitored resource name to return information about all alarms for a specific resource.

See \url{https://www.paws-r-sdk.com/docs/lightsail_get_alarms/} for full documentation.
}
\keyword{internal}
