# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Batch
#'
#' @description
#' Batch
#' 
#' Using Batch, you can run batch computing workloads on the Amazon Web
#' Services Cloud. Batch computing is a common means for developers,
#' scientists, and engineers to access large amounts of compute resources.
#' Batch uses the advantages of the batch computing to remove the
#' undifferentiated heavy lifting of configuring and managing required
#' infrastructure. At the same time, it also adopts a familiar batch
#' computing software approach. You can use Batch to efficiently provision
#' resources d, and work toward eliminating capacity constraints, reducing
#' your overall compute costs, and delivering results more quickly.
#' 
#' As a fully managed service, Batch can run batch computing workloads of
#' any scale. Batch automatically provisions compute resources and
#' optimizes workload distribution based on the quantity and scale of your
#' specific workloads. With Batch, there's no need to install or manage
#' batch computing software. This means that you can focus on analyzing
#' results and solving your specific problems instead.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}:} {\itemize{
#' \item{\strong{creds}:} {\itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' }}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' }}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}:} {\itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' }}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- batch(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- batch()
#' # This example cancels a job with the specified job ID.
#' svc$cancel_job(
#'   jobId = "1d828f65-7a4d-42e8-996d-3b900ed59dc4",
#'   reason = "Cancelling job."
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=batch_cancel_job]{cancel_job} \tab Cancels a job in an Batch job queue\cr
#'  \link[=batch_create_compute_environment]{create_compute_environment} \tab Creates an Batch compute environment\cr
#'  \link[=batch_create_job_queue]{create_job_queue} \tab Creates an Batch job queue\cr
#'  \link[=batch_create_scheduling_policy]{create_scheduling_policy} \tab Creates an Batch scheduling policy\cr
#'  \link[=batch_delete_compute_environment]{delete_compute_environment} \tab Deletes an Batch compute environment\cr
#'  \link[=batch_delete_job_queue]{delete_job_queue} \tab Deletes the specified job queue\cr
#'  \link[=batch_delete_scheduling_policy]{delete_scheduling_policy} \tab Deletes the specified scheduling policy\cr
#'  \link[=batch_deregister_job_definition]{deregister_job_definition} \tab Deregisters an Batch job definition\cr
#'  \link[=batch_describe_compute_environments]{describe_compute_environments} \tab Describes one or more of your compute environments\cr
#'  \link[=batch_describe_job_definitions]{describe_job_definitions} \tab Describes a list of job definitions\cr
#'  \link[=batch_describe_job_queues]{describe_job_queues} \tab Describes one or more of your job queues\cr
#'  \link[=batch_describe_jobs]{describe_jobs} \tab Describes a list of Batch jobs\cr
#'  \link[=batch_describe_scheduling_policies]{describe_scheduling_policies} \tab Describes one or more of your scheduling policies\cr
#'  \link[=batch_list_jobs]{list_jobs} \tab Returns a list of Batch jobs\cr
#'  \link[=batch_list_scheduling_policies]{list_scheduling_policies} \tab Returns a list of Batch scheduling policies\cr
#'  \link[=batch_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags for an Batch resource\cr
#'  \link[=batch_register_job_definition]{register_job_definition} \tab Registers an Batch job definition\cr
#'  \link[=batch_submit_job]{submit_job} \tab Submits an Batch job from a job definition\cr
#'  \link[=batch_tag_resource]{tag_resource} \tab Associates the specified tags to a resource with the specified resourceArn\cr
#'  \link[=batch_terminate_job]{terminate_job} \tab Terminates a job in a job queue\cr
#'  \link[=batch_untag_resource]{untag_resource} \tab Deletes specified tags from an Batch resource\cr
#'  \link[=batch_update_compute_environment]{update_compute_environment} \tab Updates an Batch compute environment\cr
#'  \link[=batch_update_job_queue]{update_job_queue} \tab Updates a job queue\cr
#'  \link[=batch_update_scheduling_policy]{update_scheduling_policy} \tab Updates a scheduling policy
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname batch
#' @export
batch <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .batch$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.batch <- list()

.batch$operations <- list()

.batch$metadata <- list(
  service_name = "batch",
  endpoints = list("*" = list(endpoint = "batch.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "batch.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "batch.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "batch.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Batch",
  api_version = "2016-08-10",
  signing_name = "batch",
  json_version = "1.1",
  target_prefix = ""
)

.batch$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.batch$metadata, handlers, config)
}
