% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_set_resource_access_for_bucket}
\alias{lightsail_set_resource_access_for_bucket}
\title{Sets the Amazon Lightsail resources that can access the specified
Lightsail bucket}
\usage{
lightsail_set_resource_access_for_bucket(resourceName, bucketName, access)
}
\arguments{
\item{resourceName}{[required] The name of the Lightsail instance for which to set bucket access. The
instance must be in a running or stopped state.}

\item{bucketName}{[required] The name of the bucket for which to set access to another Lightsail
resource.}

\item{access}{[required] The access setting.

The following access settings are available:
\itemize{
\item \code{allow} - Allows access to the bucket and its objects.
\item \code{deny} - Denies access to the bucket and its objects. Use this
setting to remove access for a resource previously set to \code{allow}.
}}
}
\description{
Sets the Amazon Lightsail resources that can access the specified Lightsail bucket.

See \url{https://paws-r.github.io/docs/lightsail/set_resource_access_for_bucket.html} for full documentation.
}
\keyword{internal}
