% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_update_cluster_config}
\alias{eks_update_cluster_config}
\title{Updates an Amazon EKS cluster configuration}
\usage{
eks_update_cluster_config(
  name,
  resourcesVpcConfig = NULL,
  logging = NULL,
  clientRequestToken = NULL
)
}
\arguments{
\item{name}{[required] The name of the Amazon EKS cluster to update.}

\item{resourcesVpcConfig}{}

\item{logging}{Enable or disable exporting the Kubernetes control plane logs for your
cluster to CloudWatch Logs. By default, cluster control plane logs
aren't exported to CloudWatch Logs. For more information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html}{Amazon EKS cluster control plane logs}
in the \emph{Amazon EKS User Guide} .

CloudWatch Logs ingestion, archive storage, and data scanning rates
apply to exported control plane logs. For more information, see
\href{https://aws.amazon.com/cloudwatch/pricing/}{CloudWatch Pricing}.}

\item{clientRequestToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}
}
\description{
Updates an Amazon EKS cluster configuration. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with the \code{\link[=eks_describe_update]{describe_update}} API operation.

See \url{https://paws-r.github.io/docs/eks/update_cluster_config.html} for full documentation.
}
\keyword{internal}
