% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_transit_gateway_route}
\alias{ec2_create_transit_gateway_route}
\title{Creates a static route for the specified transit gateway route table}
\usage{
ec2_create_transit_gateway_route(
  DestinationCidrBlock,
  TransitGatewayRouteTableId,
  TransitGatewayAttachmentId = NULL,
  Blackhole = NULL,
  DryRun = NULL
)
}
\arguments{
\item{DestinationCidrBlock}{[required] The CIDR range used for destination matches. Routing decisions are based
on the most specific match.}

\item{TransitGatewayRouteTableId}{[required] The ID of the transit gateway route table.}

\item{TransitGatewayAttachmentId}{The ID of the attachment.}

\item{Blackhole}{Indicates whether to drop traffic that matches this route.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Creates a static route for the specified transit gateway route table.

See \url{https://paws-r.github.io/docs/ec2/create_transit_gateway_route.html} for full documentation.
}
\keyword{internal}
