# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include apprunner_service.R
NULL

#' Associate your own domain name with the App Runner subdomain URL of your
#' App Runner service
#'
#' @description
#' Associate your own domain name with the App Runner subdomain URL of your App Runner service.
#'
#' See [https://paws-r.github.io/docs/apprunner/associate_custom_domain.html](https://paws-r.github.io/docs/apprunner/associate_custom_domain.html) for full documentation.
#'
#' @param ServiceArn &#91;required&#93; The Amazon Resource Name (ARN) of the App Runner service that you want
#' to associate a custom domain name with.
#' @param DomainName &#91;required&#93; A custom domain endpoint to associate. Specify a root domain (for
#' example, `example.com`), a subdomain (for example, `login.example.com`
#' or `admin.login.example.com`), or a wildcard (for example,
#' `*.example.com`).
#' @param EnableWWWSubdomain Set to `true` to associate the subdomain `www.DomainName ` with the App
#' Runner service in addition to the base domain.
#' 
#' Default: `true`
#'
#' @keywords internal
#'
#' @rdname apprunner_associate_custom_domain
apprunner_associate_custom_domain <- function(ServiceArn, DomainName, EnableWWWSubdomain = NULL) {
  op <- new_operation(
    name = "AssociateCustomDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$associate_custom_domain_input(ServiceArn = ServiceArn, DomainName = DomainName, EnableWWWSubdomain = EnableWWWSubdomain)
  output <- .apprunner$associate_custom_domain_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$associate_custom_domain <- apprunner_associate_custom_domain

#' Create an App Runner automatic scaling configuration resource
#'
#' @description
#' Create an App Runner automatic scaling configuration resource. App Runner requires this resource when you create or update App Runner services and you require non-default auto scaling settings. You can share an auto scaling configuration across multiple services.
#'
#' See [https://paws-r.github.io/docs/apprunner/create_auto_scaling_configuration.html](https://paws-r.github.io/docs/apprunner/create_auto_scaling_configuration.html) for full documentation.
#'
#' @param AutoScalingConfigurationName &#91;required&#93; A name for the auto scaling configuration. When you use it for the first
#' time in an Amazon Web Services Region, App Runner creates revision
#' number `1` of this name. When you use the same name in subsequent calls,
#' App Runner creates incremental revisions of the configuration.
#' 
#' The name `DefaultConfiguration` is reserved (it's the configuration that
#' App Runner uses if you don't provide a custome one). You can't use it to
#' create a new auto scaling configuration, and you can't create a revision
#' of it.
#' 
#' When you want to use your own auto scaling configuration for your App
#' Runner service, *create a configuration with a different name*, and then
#' provide it when you create or update your service.
#' @param MaxConcurrency The maximum number of concurrent requests that you want an instance to
#' process. If the number of concurrent requests exceeds this limit, App
#' Runner scales up your service.
#' 
#' Default: `100`
#' @param MinSize The minimum number of instances that App Runner provisions for your
#' service. The service always has at least `MinSize` provisioned
#' instances. Some of them actively serve traffic. The rest of them
#' (provisioned and inactive instances) are a cost-effective compute
#' capacity reserve and are ready to be quickly activated. You pay for
#' memory usage of all the provisioned instances. You pay for CPU usage of
#' only the active subset.
#' 
#' App Runner temporarily doubles the number of provisioned instances
#' during deployments, to maintain the same capacity for both old and new
#' code.
#' 
#' Default: `1`
#' @param MaxSize The maximum number of instances that your service scales up to. At most
#' `MaxSize` instances actively serve traffic for your service.
#' 
#' Default: `25`
#' @param Tags A list of metadata items that you can associate with your auto scaling
#' configuration resource. A tag is a key-value pair.
#'
#' @keywords internal
#'
#' @rdname apprunner_create_auto_scaling_configuration
apprunner_create_auto_scaling_configuration <- function(AutoScalingConfigurationName, MaxConcurrency = NULL, MinSize = NULL, MaxSize = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateAutoScalingConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$create_auto_scaling_configuration_input(AutoScalingConfigurationName = AutoScalingConfigurationName, MaxConcurrency = MaxConcurrency, MinSize = MinSize, MaxSize = MaxSize, Tags = Tags)
  output <- .apprunner$create_auto_scaling_configuration_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$create_auto_scaling_configuration <- apprunner_create_auto_scaling_configuration

#' Create an App Runner connection resource
#'
#' @description
#' Create an App Runner connection resource. App Runner requires a connection resource when you create App Runner services that access private repositories from certain third-party providers. You can share a connection across multiple services.
#'
#' See [https://paws-r.github.io/docs/apprunner/create_connection.html](https://paws-r.github.io/docs/apprunner/create_connection.html) for full documentation.
#'
#' @param ConnectionName &#91;required&#93; A name for the new connection. It must be unique across all App Runner
#' connections for the Amazon Web Services account in the Amazon Web
#' Services Region.
#' @param ProviderType &#91;required&#93; The source repository provider.
#' @param Tags A list of metadata items that you can associate with your connection
#' resource. A tag is a key-value pair.
#'
#' @keywords internal
#'
#' @rdname apprunner_create_connection
apprunner_create_connection <- function(ConnectionName, ProviderType, Tags = NULL) {
  op <- new_operation(
    name = "CreateConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$create_connection_input(ConnectionName = ConnectionName, ProviderType = ProviderType, Tags = Tags)
  output <- .apprunner$create_connection_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$create_connection <- apprunner_create_connection

#' Create an App Runner observability configuration resource
#'
#' @description
#' Create an App Runner observability configuration resource. App Runner requires this resource when you create or update App Runner services and you want to enable non-default observability features. You can share an observability configuration across multiple services.
#'
#' See [https://paws-r.github.io/docs/apprunner/create_observability_configuration.html](https://paws-r.github.io/docs/apprunner/create_observability_configuration.html) for full documentation.
#'
#' @param ObservabilityConfigurationName &#91;required&#93; A name for the observability configuration. When you use it for the
#' first time in an Amazon Web Services Region, App Runner creates revision
#' number `1` of this name. When you use the same name in subsequent calls,
#' App Runner creates incremental revisions of the configuration.
#' 
#' The name `DefaultConfiguration` is reserved. You can't use it to create
#' a new observability configuration, and you can't create a revision of
#' it.
#' 
#' When you want to use your own observability configuration for your App
#' Runner service, *create a configuration with a different name*, and then
#' provide it when you create or update your service.
#' @param TraceConfiguration The configuration of the tracing feature within this observability
#' configuration. If you don't specify it, App Runner doesn't enable
#' tracing.
#' @param Tags A list of metadata items that you can associate with your observability
#' configuration resource. A tag is a key-value pair.
#'
#' @keywords internal
#'
#' @rdname apprunner_create_observability_configuration
apprunner_create_observability_configuration <- function(ObservabilityConfigurationName, TraceConfiguration = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateObservabilityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$create_observability_configuration_input(ObservabilityConfigurationName = ObservabilityConfigurationName, TraceConfiguration = TraceConfiguration, Tags = Tags)
  output <- .apprunner$create_observability_configuration_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$create_observability_configuration <- apprunner_create_observability_configuration

#' Create an App Runner service
#'
#' @description
#' Create an App Runner service. After the service is created, the action also automatically starts a deployment.
#'
#' See [https://paws-r.github.io/docs/apprunner/create_service.html](https://paws-r.github.io/docs/apprunner/create_service.html) for full documentation.
#'
#' @param ServiceName &#91;required&#93; A name for the App Runner service. It must be unique across all the
#' running App Runner services in your Amazon Web Services account in the
#' Amazon Web Services Region.
#' @param SourceConfiguration &#91;required&#93; The source to deploy to the App Runner service. It can be a code or an
#' image repository.
#' @param InstanceConfiguration The runtime configuration of instances (scaling units) of your service.
#' @param Tags An optional list of metadata items that you can associate with the App
#' Runner service resource. A tag is a key-value pair.
#' @param EncryptionConfiguration An optional custom encryption key that App Runner uses to encrypt the
#' copy of your source repository that it maintains and your service logs.
#' By default, App Runner uses an Amazon Web Services managed key.
#' @param HealthCheckConfiguration The settings for the health check that App Runner performs to monitor
#' the health of the App Runner service.
#' @param AutoScalingConfigurationArn The Amazon Resource Name (ARN) of an App Runner automatic scaling
#' configuration resource that you want to associate with your service. If
#' not provided, App Runner associates the latest revision of a default
#' auto scaling configuration.
#' 
#' Specify an ARN with a name and a revision number to associate that
#' revision. For example:
#' `arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability/3`
#' 
#' Specify just the name to associate the latest revision. For example:
#' `arn:aws:apprunner:us-east-1:123456789012:autoscalingconfiguration/high-availability`
#' @param NetworkConfiguration Configuration settings related to network traffic of the web application
#' that the App Runner service runs.
#' @param ObservabilityConfiguration The observability configuration of your service.
#'
#' @keywords internal
#'
#' @rdname apprunner_create_service
apprunner_create_service <- function(ServiceName, SourceConfiguration, InstanceConfiguration = NULL, Tags = NULL, EncryptionConfiguration = NULL, HealthCheckConfiguration = NULL, AutoScalingConfigurationArn = NULL, NetworkConfiguration = NULL, ObservabilityConfiguration = NULL) {
  op <- new_operation(
    name = "CreateService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$create_service_input(ServiceName = ServiceName, SourceConfiguration = SourceConfiguration, InstanceConfiguration = InstanceConfiguration, Tags = Tags, EncryptionConfiguration = EncryptionConfiguration, HealthCheckConfiguration = HealthCheckConfiguration, AutoScalingConfigurationArn = AutoScalingConfigurationArn, NetworkConfiguration = NetworkConfiguration, ObservabilityConfiguration = ObservabilityConfiguration)
  output <- .apprunner$create_service_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$create_service <- apprunner_create_service

#' Create an App Runner VPC connector resource
#'
#' @description
#' Create an App Runner VPC connector resource. App Runner requires this resource when you want to associate your App Runner service to a custom Amazon Virtual Private Cloud (Amazon VPC).
#'
#' See [https://paws-r.github.io/docs/apprunner/create_vpc_connector.html](https://paws-r.github.io/docs/apprunner/create_vpc_connector.html) for full documentation.
#'
#' @param VpcConnectorName &#91;required&#93; A name for the VPC connector.
#' @param Subnets &#91;required&#93; A list of IDs of subnets that App Runner should use when it associates
#' your service with a custom Amazon VPC. Specify IDs of subnets of a
#' single Amazon VPC. App Runner determines the Amazon VPC from the subnets
#' you specify.
#' 
#' App Runner currently only provides support for IPv4.
#' @param SecurityGroups A list of IDs of security groups that App Runner should use for access
#' to Amazon Web Services resources under the specified subnets. If not
#' specified, App Runner uses the default security group of the Amazon VPC.
#' The default security group allows all outbound traffic.
#' @param Tags A list of metadata items that you can associate with your VPC connector
#' resource. A tag is a key-value pair.
#'
#' @keywords internal
#'
#' @rdname apprunner_create_vpc_connector
apprunner_create_vpc_connector <- function(VpcConnectorName, Subnets, SecurityGroups = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateVpcConnector",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$create_vpc_connector_input(VpcConnectorName = VpcConnectorName, Subnets = Subnets, SecurityGroups = SecurityGroups, Tags = Tags)
  output <- .apprunner$create_vpc_connector_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$create_vpc_connector <- apprunner_create_vpc_connector

#' Delete an App Runner automatic scaling configuration resource
#'
#' @description
#' Delete an App Runner automatic scaling configuration resource. You can delete a specific revision or the latest active revision. You can't delete a configuration that's used by one or more App Runner services.
#'
#' See [https://paws-r.github.io/docs/apprunner/delete_auto_scaling_configuration.html](https://paws-r.github.io/docs/apprunner/delete_auto_scaling_configuration.html) for full documentation.
#'
#' @param AutoScalingConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the App Runner auto scaling
#' configuration that you want to delete.
#' 
#' The ARN can be a full auto scaling configuration ARN, or a partial ARN
#' ending with either `.../name ` or `.../name/revision `. If a revision
#' isn't specified, the latest active revision is deleted.
#'
#' @keywords internal
#'
#' @rdname apprunner_delete_auto_scaling_configuration
apprunner_delete_auto_scaling_configuration <- function(AutoScalingConfigurationArn) {
  op <- new_operation(
    name = "DeleteAutoScalingConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$delete_auto_scaling_configuration_input(AutoScalingConfigurationArn = AutoScalingConfigurationArn)
  output <- .apprunner$delete_auto_scaling_configuration_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$delete_auto_scaling_configuration <- apprunner_delete_auto_scaling_configuration

#' Delete an App Runner connection
#'
#' @description
#' Delete an App Runner connection. You must first ensure that there are no running App Runner services that use this connection. If there are any, the [`delete_connection`][apprunner_delete_connection] action fails.
#'
#' See [https://paws-r.github.io/docs/apprunner/delete_connection.html](https://paws-r.github.io/docs/apprunner/delete_connection.html) for full documentation.
#'
#' @param ConnectionArn &#91;required&#93; The Amazon Resource Name (ARN) of the App Runner connection that you
#' want to delete.
#'
#' @keywords internal
#'
#' @rdname apprunner_delete_connection
apprunner_delete_connection <- function(ConnectionArn) {
  op <- new_operation(
    name = "DeleteConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$delete_connection_input(ConnectionArn = ConnectionArn)
  output <- .apprunner$delete_connection_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$delete_connection <- apprunner_delete_connection

#' Delete an App Runner observability configuration resource
#'
#' @description
#' Delete an App Runner observability configuration resource. You can delete a specific revision or the latest active revision. You can't delete a configuration that's used by one or more App Runner services.
#'
#' See [https://paws-r.github.io/docs/apprunner/delete_observability_configuration.html](https://paws-r.github.io/docs/apprunner/delete_observability_configuration.html) for full documentation.
#'
#' @param ObservabilityConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the App Runner observability
#' configuration that you want to delete.
#' 
#' The ARN can be a full observability configuration ARN, or a partial ARN
#' ending with either `.../name ` or `.../name/revision `. If a revision
#' isn't specified, the latest active revision is deleted.
#'
#' @keywords internal
#'
#' @rdname apprunner_delete_observability_configuration
apprunner_delete_observability_configuration <- function(ObservabilityConfigurationArn) {
  op <- new_operation(
    name = "DeleteObservabilityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$delete_observability_configuration_input(ObservabilityConfigurationArn = ObservabilityConfigurationArn)
  output <- .apprunner$delete_observability_configuration_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$delete_observability_configuration <- apprunner_delete_observability_configuration

#' Delete an App Runner service
#'
#' @description
#' Delete an App Runner service.
#'
#' See [https://paws-r.github.io/docs/apprunner/delete_service.html](https://paws-r.github.io/docs/apprunner/delete_service.html) for full documentation.
#'
#' @param ServiceArn &#91;required&#93; The Amazon Resource Name (ARN) of the App Runner service that you want
#' to delete.
#'
#' @keywords internal
#'
#' @rdname apprunner_delete_service
apprunner_delete_service <- function(ServiceArn) {
  op <- new_operation(
    name = "DeleteService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$delete_service_input(ServiceArn = ServiceArn)
  output <- .apprunner$delete_service_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$delete_service <- apprunner_delete_service

#' Delete an App Runner VPC connector resource
#'
#' @description
#' Delete an App Runner VPC connector resource. You can't delete a connector that's used by one or more App Runner services.
#'
#' See [https://paws-r.github.io/docs/apprunner/delete_vpc_connector.html](https://paws-r.github.io/docs/apprunner/delete_vpc_connector.html) for full documentation.
#'
#' @param VpcConnectorArn &#91;required&#93; The Amazon Resource Name (ARN) of the App Runner VPC connector that you
#' want to delete.
#' 
#' The ARN must be a full VPC connector ARN.
#'
#' @keywords internal
#'
#' @rdname apprunner_delete_vpc_connector
apprunner_delete_vpc_connector <- function(VpcConnectorArn) {
  op <- new_operation(
    name = "DeleteVpcConnector",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$delete_vpc_connector_input(VpcConnectorArn = VpcConnectorArn)
  output <- .apprunner$delete_vpc_connector_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$delete_vpc_connector <- apprunner_delete_vpc_connector

#' Return a full description of an App Runner automatic scaling
#' configuration resource
#'
#' @description
#' Return a full description of an App Runner automatic scaling configuration resource.
#'
#' See [https://paws-r.github.io/docs/apprunner/describe_auto_scaling_configuration.html](https://paws-r.github.io/docs/apprunner/describe_auto_scaling_configuration.html) for full documentation.
#'
#' @param AutoScalingConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the App Runner auto scaling
#' configuration that you want a description for.
#' 
#' The ARN can be a full auto scaling configuration ARN, or a partial ARN
#' ending with either `.../name ` or `.../name/revision `. If a revision
#' isn't specified, the latest active revision is described.
#'
#' @keywords internal
#'
#' @rdname apprunner_describe_auto_scaling_configuration
apprunner_describe_auto_scaling_configuration <- function(AutoScalingConfigurationArn) {
  op <- new_operation(
    name = "DescribeAutoScalingConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$describe_auto_scaling_configuration_input(AutoScalingConfigurationArn = AutoScalingConfigurationArn)
  output <- .apprunner$describe_auto_scaling_configuration_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$describe_auto_scaling_configuration <- apprunner_describe_auto_scaling_configuration

#' Return a description of custom domain names that are associated with an
#' App Runner service
#'
#' @description
#' Return a description of custom domain names that are associated with an App Runner service.
#'
#' See [https://paws-r.github.io/docs/apprunner/describe_custom_domains.html](https://paws-r.github.io/docs/apprunner/describe_custom_domains.html) for full documentation.
#'
#' @param ServiceArn &#91;required&#93; The Amazon Resource Name (ARN) of the App Runner service that you want
#' associated custom domain names to be described for.
#' @param NextToken A token from a previous result page. It's used for a paginated request.
#' The request retrieves the next result page. All other parameter values
#' must be identical to the ones that are specified in the initial request.
#' 
#' If you don't specify `NextToken`, the request retrieves the first result
#' page.
#' @param MaxResults The maximum number of results that each response (result page) can
#' include. It's used for a paginated request.
#' 
#' If you don't specify `MaxResults`, the request retrieves all available
#' results in a single response.
#'
#' @keywords internal
#'
#' @rdname apprunner_describe_custom_domains
apprunner_describe_custom_domains <- function(ServiceArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeCustomDomains",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$describe_custom_domains_input(ServiceArn = ServiceArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .apprunner$describe_custom_domains_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$describe_custom_domains <- apprunner_describe_custom_domains

#' Return a full description of an App Runner observability configuration
#' resource
#'
#' @description
#' Return a full description of an App Runner observability configuration resource.
#'
#' See [https://paws-r.github.io/docs/apprunner/describe_observability_configuration.html](https://paws-r.github.io/docs/apprunner/describe_observability_configuration.html) for full documentation.
#'
#' @param ObservabilityConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the App Runner observability
#' configuration that you want a description for.
#' 
#' The ARN can be a full observability configuration ARN, or a partial ARN
#' ending with either `.../name ` or `.../name/revision `. If a revision
#' isn't specified, the latest active revision is described.
#'
#' @keywords internal
#'
#' @rdname apprunner_describe_observability_configuration
apprunner_describe_observability_configuration <- function(ObservabilityConfigurationArn) {
  op <- new_operation(
    name = "DescribeObservabilityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$describe_observability_configuration_input(ObservabilityConfigurationArn = ObservabilityConfigurationArn)
  output <- .apprunner$describe_observability_configuration_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$describe_observability_configuration <- apprunner_describe_observability_configuration

#' Return a full description of an App Runner service
#'
#' @description
#' Return a full description of an App Runner service.
#'
#' See [https://paws-r.github.io/docs/apprunner/describe_service.html](https://paws-r.github.io/docs/apprunner/describe_service.html) for full documentation.
#'
#' @param ServiceArn &#91;required&#93; The Amazon Resource Name (ARN) of the App Runner service that you want a
#' description for.
#'
#' @keywords internal
#'
#' @rdname apprunner_describe_service
apprunner_describe_service <- function(ServiceArn) {
  op <- new_operation(
    name = "DescribeService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$describe_service_input(ServiceArn = ServiceArn)
  output <- .apprunner$describe_service_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$describe_service <- apprunner_describe_service

#' Return a description of an App Runner VPC connector resource
#'
#' @description
#' Return a description of an App Runner VPC connector resource.
#'
#' See [https://paws-r.github.io/docs/apprunner/describe_vpc_connector.html](https://paws-r.github.io/docs/apprunner/describe_vpc_connector.html) for full documentation.
#'
#' @param VpcConnectorArn &#91;required&#93; The Amazon Resource Name (ARN) of the App Runner VPC connector that you
#' want a description for.
#' 
#' The ARN must be a full VPC connector ARN.
#'
#' @keywords internal
#'
#' @rdname apprunner_describe_vpc_connector
apprunner_describe_vpc_connector <- function(VpcConnectorArn) {
  op <- new_operation(
    name = "DescribeVpcConnector",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$describe_vpc_connector_input(VpcConnectorArn = VpcConnectorArn)
  output <- .apprunner$describe_vpc_connector_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$describe_vpc_connector <- apprunner_describe_vpc_connector

#' Disassociate a custom domain name from an App Runner service
#'
#' @description
#' Disassociate a custom domain name from an App Runner service.
#'
#' See [https://paws-r.github.io/docs/apprunner/disassociate_custom_domain.html](https://paws-r.github.io/docs/apprunner/disassociate_custom_domain.html) for full documentation.
#'
#' @param ServiceArn &#91;required&#93; The Amazon Resource Name (ARN) of the App Runner service that you want
#' to disassociate a custom domain name from.
#' @param DomainName &#91;required&#93; The domain name that you want to disassociate from the App Runner
#' service.
#'
#' @keywords internal
#'
#' @rdname apprunner_disassociate_custom_domain
apprunner_disassociate_custom_domain <- function(ServiceArn, DomainName) {
  op <- new_operation(
    name = "DisassociateCustomDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$disassociate_custom_domain_input(ServiceArn = ServiceArn, DomainName = DomainName)
  output <- .apprunner$disassociate_custom_domain_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$disassociate_custom_domain <- apprunner_disassociate_custom_domain

#' Returns a list of active App Runner automatic scaling configurations in
#' your Amazon Web Services account
#'
#' @description
#' Returns a list of active App Runner automatic scaling configurations in your Amazon Web Services account. You can query the revisions for a specific configuration name or the revisions for all active configurations in your account. You can optionally query only the latest revision of each requested name.
#'
#' See [https://paws-r.github.io/docs/apprunner/list_auto_scaling_configurations.html](https://paws-r.github.io/docs/apprunner/list_auto_scaling_configurations.html) for full documentation.
#'
#' @param AutoScalingConfigurationName The name of the App Runner auto scaling configuration that you want to
#' list. If specified, App Runner lists revisions that share this name. If
#' not specified, App Runner returns revisions of all active
#' configurations.
#' @param LatestOnly Set to `true` to list only the latest revision for each requested
#' configuration name.
#' 
#' Set to `false` to list all revisions for each requested configuration
#' name.
#' 
#' Default: `true`
#' @param MaxResults The maximum number of results to include in each response (result page).
#' It's used for a paginated request.
#' 
#' If you don't specify `MaxResults`, the request retrieves all available
#' results in a single response.
#' @param NextToken A token from a previous result page. It's used for a paginated request.
#' The request retrieves the next result page. All other parameter values
#' must be identical to the ones that are specified in the initial request.
#' 
#' If you don't specify `NextToken`, the request retrieves the first result
#' page.
#'
#' @keywords internal
#'
#' @rdname apprunner_list_auto_scaling_configurations
apprunner_list_auto_scaling_configurations <- function(AutoScalingConfigurationName = NULL, LatestOnly = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAutoScalingConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$list_auto_scaling_configurations_input(AutoScalingConfigurationName = AutoScalingConfigurationName, LatestOnly = LatestOnly, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apprunner$list_auto_scaling_configurations_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$list_auto_scaling_configurations <- apprunner_list_auto_scaling_configurations

#' Returns a list of App Runner connections that are associated with your
#' Amazon Web Services account
#'
#' @description
#' Returns a list of App Runner connections that are associated with your Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/apprunner/list_connections.html](https://paws-r.github.io/docs/apprunner/list_connections.html) for full documentation.
#'
#' @param ConnectionName If specified, only this connection is returned. If not specified, the
#' result isn't filtered by name.
#' @param MaxResults The maximum number of results to include in each response (result page).
#' Used for a paginated request.
#' 
#' If you don't specify `MaxResults`, the request retrieves all available
#' results in a single response.
#' @param NextToken A token from a previous result page. Used for a paginated request. The
#' request retrieves the next result page. All other parameter values must
#' be identical to the ones specified in the initial request.
#' 
#' If you don't specify `NextToken`, the request retrieves the first result
#' page.
#'
#' @keywords internal
#'
#' @rdname apprunner_list_connections
apprunner_list_connections <- function(ConnectionName = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListConnections",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$list_connections_input(ConnectionName = ConnectionName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apprunner$list_connections_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$list_connections <- apprunner_list_connections

#' Returns a list of active App Runner observability configurations in your
#' Amazon Web Services account
#'
#' @description
#' Returns a list of active App Runner observability configurations in your Amazon Web Services account. You can query the revisions for a specific configuration name or the revisions for all active configurations in your account. You can optionally query only the latest revision of each requested name.
#'
#' See [https://paws-r.github.io/docs/apprunner/list_observability_configurations.html](https://paws-r.github.io/docs/apprunner/list_observability_configurations.html) for full documentation.
#'
#' @param ObservabilityConfigurationName The name of the App Runner observability configuration that you want to
#' list. If specified, App Runner lists revisions that share this name. If
#' not specified, App Runner returns revisions of all active
#' configurations.
#' @param LatestOnly Set to `true` to list only the latest revision for each requested
#' configuration name.
#' 
#' Set to `false` to list all revisions for each requested configuration
#' name.
#' 
#' Default: `true`
#' @param MaxResults The maximum number of results to include in each response (result page).
#' It's used for a paginated request.
#' 
#' If you don't specify `MaxResults`, the request retrieves all available
#' results in a single response.
#' @param NextToken A token from a previous result page. It's used for a paginated request.
#' The request retrieves the next result page. All other parameter values
#' must be identical to the ones that are specified in the initial request.
#' 
#' If you don't specify `NextToken`, the request retrieves the first result
#' page.
#'
#' @keywords internal
#'
#' @rdname apprunner_list_observability_configurations
apprunner_list_observability_configurations <- function(ObservabilityConfigurationName = NULL, LatestOnly = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListObservabilityConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$list_observability_configurations_input(ObservabilityConfigurationName = ObservabilityConfigurationName, LatestOnly = LatestOnly, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apprunner$list_observability_configurations_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$list_observability_configurations <- apprunner_list_observability_configurations

#' Return a list of operations that occurred on an App Runner service
#'
#' @description
#' Return a list of operations that occurred on an App Runner service.
#'
#' See [https://paws-r.github.io/docs/apprunner/list_operations.html](https://paws-r.github.io/docs/apprunner/list_operations.html) for full documentation.
#'
#' @param ServiceArn &#91;required&#93; The Amazon Resource Name (ARN) of the App Runner service that you want a
#' list of operations for.
#' @param NextToken A token from a previous result page. It's used for a paginated request.
#' The request retrieves the next result page. All other parameter values
#' must be identical to the ones specified in the initial request.
#' 
#' If you don't specify `NextToken`, the request retrieves the first result
#' page.
#' @param MaxResults The maximum number of results to include in each response (result page).
#' It's used for a paginated request.
#' 
#' If you don't specify `MaxResults`, the request retrieves all available
#' results in a single response.
#'
#' @keywords internal
#'
#' @rdname apprunner_list_operations
apprunner_list_operations <- function(ServiceArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListOperations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$list_operations_input(ServiceArn = ServiceArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .apprunner$list_operations_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$list_operations <- apprunner_list_operations

#' Returns a list of running App Runner services in your Amazon Web
#' Services account
#'
#' @description
#' Returns a list of running App Runner services in your Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/apprunner/list_services.html](https://paws-r.github.io/docs/apprunner/list_services.html) for full documentation.
#'
#' @param NextToken A token from a previous result page. Used for a paginated request. The
#' request retrieves the next result page. All other parameter values must
#' be identical to the ones specified in the initial request.
#' 
#' If you don't specify `NextToken`, the request retrieves the first result
#' page.
#' @param MaxResults The maximum number of results to include in each response (result page).
#' It's used for a paginated request.
#' 
#' If you don't specify `MaxResults`, the request retrieves all available
#' results in a single response.
#'
#' @keywords internal
#'
#' @rdname apprunner_list_services
apprunner_list_services <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListServices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$list_services_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .apprunner$list_services_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$list_services <- apprunner_list_services

#' List tags that are associated with for an App Runner resource
#'
#' @description
#' List tags that are associated with for an App Runner resource. The response contains a list of tag key-value pairs.
#'
#' See [https://paws-r.github.io/docs/apprunner/list_tags_for_resource.html](https://paws-r.github.io/docs/apprunner/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that a tag list is
#' requested for.
#' 
#' It must be the ARN of an App Runner resource.
#'
#' @keywords internal
#'
#' @rdname apprunner_list_tags_for_resource
apprunner_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .apprunner$list_tags_for_resource_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$list_tags_for_resource <- apprunner_list_tags_for_resource

#' Returns a list of App Runner VPC connectors in your Amazon Web Services
#' account
#'
#' @description
#' Returns a list of App Runner VPC connectors in your Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/apprunner/list_vpc_connectors.html](https://paws-r.github.io/docs/apprunner/list_vpc_connectors.html) for full documentation.
#'
#' @param MaxResults The maximum number of results to include in each response (result page).
#' It's used for a paginated request.
#' 
#' If you don't specify `MaxResults`, the request retrieves all available
#' results in a single response.
#' @param NextToken A token from a previous result page. It's used for a paginated request.
#' The request retrieves the next result page. All other parameter values
#' must be identical to the ones that are specified in the initial request.
#' 
#' If you don't specify `NextToken`, the request retrieves the first result
#' page.
#'
#' @keywords internal
#'
#' @rdname apprunner_list_vpc_connectors
apprunner_list_vpc_connectors <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListVpcConnectors",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$list_vpc_connectors_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .apprunner$list_vpc_connectors_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$list_vpc_connectors <- apprunner_list_vpc_connectors

#' Pause an active App Runner service
#'
#' @description
#' Pause an active App Runner service. App Runner reduces compute capacity for the service to zero and loses state (for example, ephemeral storage is removed).
#'
#' See [https://paws-r.github.io/docs/apprunner/pause_service.html](https://paws-r.github.io/docs/apprunner/pause_service.html) for full documentation.
#'
#' @param ServiceArn &#91;required&#93; The Amazon Resource Name (ARN) of the App Runner service that you want
#' to pause.
#'
#' @keywords internal
#'
#' @rdname apprunner_pause_service
apprunner_pause_service <- function(ServiceArn) {
  op <- new_operation(
    name = "PauseService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$pause_service_input(ServiceArn = ServiceArn)
  output <- .apprunner$pause_service_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$pause_service <- apprunner_pause_service

#' Resume an active App Runner service
#'
#' @description
#' Resume an active App Runner service. App Runner provisions compute capacity for the service.
#'
#' See [https://paws-r.github.io/docs/apprunner/resume_service.html](https://paws-r.github.io/docs/apprunner/resume_service.html) for full documentation.
#'
#' @param ServiceArn &#91;required&#93; The Amazon Resource Name (ARN) of the App Runner service that you want
#' to resume.
#'
#' @keywords internal
#'
#' @rdname apprunner_resume_service
apprunner_resume_service <- function(ServiceArn) {
  op <- new_operation(
    name = "ResumeService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$resume_service_input(ServiceArn = ServiceArn)
  output <- .apprunner$resume_service_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$resume_service <- apprunner_resume_service

#' Initiate a manual deployment of the latest commit in a source code
#' repository or the latest image in a source image repository to an App
#' Runner service
#'
#' @description
#' Initiate a manual deployment of the latest commit in a source code repository or the latest image in a source image repository to an App Runner service.
#'
#' See [https://paws-r.github.io/docs/apprunner/start_deployment.html](https://paws-r.github.io/docs/apprunner/start_deployment.html) for full documentation.
#'
#' @param ServiceArn &#91;required&#93; The Amazon Resource Name (ARN) of the App Runner service that you want
#' to manually deploy to.
#'
#' @keywords internal
#'
#' @rdname apprunner_start_deployment
apprunner_start_deployment <- function(ServiceArn) {
  op <- new_operation(
    name = "StartDeployment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$start_deployment_input(ServiceArn = ServiceArn)
  output <- .apprunner$start_deployment_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$start_deployment <- apprunner_start_deployment

#' Add tags to, or update the tag values of, an App Runner resource
#'
#' @description
#' Add tags to, or update the tag values of, an App Runner resource. A tag is a key-value pair.
#'
#' See [https://paws-r.github.io/docs/apprunner/tag_resource.html](https://paws-r.github.io/docs/apprunner/tag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to update
#' tags for.
#' 
#' It must be the ARN of an App Runner resource.
#' @param Tags &#91;required&#93; A list of tag key-value pairs to add or update. If a key is new to the
#' resource, the tag is added with the provided value. If a key is already
#' associated with the resource, the value of the tag is updated.
#'
#' @keywords internal
#'
#' @rdname apprunner_tag_resource
apprunner_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .apprunner$tag_resource_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$tag_resource <- apprunner_tag_resource

#' Remove tags from an App Runner resource
#'
#' @description
#' Remove tags from an App Runner resource.
#'
#' See [https://paws-r.github.io/docs/apprunner/untag_resource.html](https://paws-r.github.io/docs/apprunner/untag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to remove
#' tags from.
#' 
#' It must be the ARN of an App Runner resource.
#' @param TagKeys &#91;required&#93; A list of tag keys that you want to remove.
#'
#' @keywords internal
#'
#' @rdname apprunner_untag_resource
apprunner_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .apprunner$untag_resource_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$untag_resource <- apprunner_untag_resource

#' Update an App Runner service
#'
#' @description
#' Update an App Runner service. You can update the source configuration and instance configuration of the service. You can also update the ARN of the auto scaling configuration resource that's associated with the service. However, you can't change the name or the encryption configuration of the service. These can be set only when you create the service.
#'
#' See [https://paws-r.github.io/docs/apprunner/update_service.html](https://paws-r.github.io/docs/apprunner/update_service.html) for full documentation.
#'
#' @param ServiceArn &#91;required&#93; The Amazon Resource Name (ARN) of the App Runner service that you want
#' to update.
#' @param SourceConfiguration The source configuration to apply to the App Runner service.
#' 
#' You can change the configuration of the code or image repository that
#' the service uses. However, you can't switch from code to image or the
#' other way around. This means that you must provide the same structure
#' member of `SourceConfiguration` that you originally included when you
#' created the service. Specifically, you can include either
#' `CodeRepository` or `ImageRepository`. To update the source
#' configuration, set the values to members of the structure that you
#' include.
#' @param InstanceConfiguration The runtime configuration to apply to instances (scaling units) of your
#' service.
#' @param AutoScalingConfigurationArn The Amazon Resource Name (ARN) of an App Runner automatic scaling
#' configuration resource that you want to associate with the App Runner
#' service.
#' @param HealthCheckConfiguration The settings for the health check that App Runner performs to monitor
#' the health of the App Runner service.
#' @param NetworkConfiguration Configuration settings related to network traffic of the web application
#' that the App Runner service runs.
#' @param ObservabilityConfiguration The observability configuration of your service.
#'
#' @keywords internal
#'
#' @rdname apprunner_update_service
apprunner_update_service <- function(ServiceArn, SourceConfiguration = NULL, InstanceConfiguration = NULL, AutoScalingConfigurationArn = NULL, HealthCheckConfiguration = NULL, NetworkConfiguration = NULL, ObservabilityConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .apprunner$update_service_input(ServiceArn = ServiceArn, SourceConfiguration = SourceConfiguration, InstanceConfiguration = InstanceConfiguration, AutoScalingConfigurationArn = AutoScalingConfigurationArn, HealthCheckConfiguration = HealthCheckConfiguration, NetworkConfiguration = NetworkConfiguration, ObservabilityConfiguration = ObservabilityConfiguration)
  output <- .apprunner$update_service_output()
  config <- get_config()
  svc <- .apprunner$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apprunner$operations$update_service <- apprunner_update_service
