% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_fleet}
\alias{ec2_modify_fleet}
\title{Modifies the specified EC2 Fleet}
\usage{
ec2_modify_fleet(DryRun, ExcessCapacityTerminationPolicy, FleetId,
  TargetCapacitySpecification)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ExcessCapacityTerminationPolicy}{Indicates whether running instances should be terminated if the total
target capacity of the EC2 Fleet is decreased below the current size of
the EC2 Fleet.}

\item{FleetId}{[required] The ID of the EC2 Fleet.}

\item{TargetCapacitySpecification}{[required] The size of the EC2 Fleet.}
}
\description{
Modifies the specified EC2 Fleet.
}
\details{
You can only modify an EC2 Fleet request of type \code{maintain}.

While the EC2 Fleet is being modified, it is in the \code{modifying} state.

To scale up your EC2 Fleet, increase its target capacity. The EC2 Fleet
launches the additional Spot Instances according to the allocation
strategy for the EC2 Fleet request. If the allocation strategy is
\code{lowest-price}, the EC2 Fleet launches instances using the Spot Instance
pool with the lowest price. If the allocation strategy is \code{diversified},
the EC2 Fleet distributes the instances across the Spot Instance pools.
If the allocation strategy is \code{capacity-optimized}, EC2 Fleet launches
instances from Spot Instance pools with optimal capacity for the number
of instances that are launching.

To scale down your EC2 Fleet, decrease its target capacity. First, the
EC2 Fleet cancels any open requests that exceed the new target capacity.
You can request that the EC2 Fleet terminate Spot Instances until the
size of the fleet no longer exceeds the new target capacity. If the
allocation strategy is \code{lowest-price}, the EC2 Fleet terminates the
instances with the highest price per unit. If the allocation strategy is
\code{capacity-optimized}, the EC2 Fleet terminates the instances in the Spot
Instance pools that have the least available Spot Instance capacity. If
the allocation strategy is \code{diversified}, the EC2 Fleet terminates
instances across the Spot Instance pools. Alternatively, you can request
that the EC2 Fleet keep the fleet at its current size, but not replace
any Spot Instances that are interrupted or that you terminate manually.

If you are finished with your EC2 Fleet for now, but will use it again
later, you can set the target capacity to 0.
}
\section{Request syntax}{
\preformatted{svc$modify_fleet(
  DryRun = TRUE|FALSE,
  ExcessCapacityTerminationPolicy = "no-termination"|"termination",
  FleetId = "string",
  TargetCapacitySpecification = list(
    TotalTargetCapacity = 123,
    OnDemandTargetCapacity = 123,
    SpotTargetCapacity = 123,
    DefaultTargetCapacityType = "spot"|"on-demand"
  )
)
}
}

\keyword{internal}
