% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_attach_certificate_to_distribution}
\alias{lightsail_attach_certificate_to_distribution}
\title{Attaches an SSL/TLS certificate to your Amazon Lightsail content
delivery network (CDN) distribution}
\usage{
lightsail_attach_certificate_to_distribution(distributionName,
  certificateName)
}
\arguments{
\item{distributionName}{[required] The name of the distribution that the certificate will be attached to.

Use the \code{\link[=lightsail_get_distributions]{get_distributions}} action to get
a list of distribution names that you can specify.}

\item{certificateName}{[required] The name of the certificate to attach to a distribution.

Only certificates with a status of \code{ISSUED} can be attached to a
distribution.

Use the \code{\link[=lightsail_get_certificates]{get_certificates}} action to get a
list of certificate names that you can specify.

This is the name of the certificate resource type and is used only to
reference the certificate in other API actions. It can be different than
the domain name of the certificate. For example, your certificate name
might be \code{WordPress-Blog-Certificate} and the domain name of the
certificate might be \code{example.com}.}
}
\value{
A list with the following syntax:\preformatted{list(
  operation = list(
    id = "string",
    resourceName = "string",
    resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
    createdAt = as.POSIXct(
      "2015-01-01"
    ),
    location = list(
      availabilityZone = "string",
      regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
    ),
    isTerminal = TRUE|FALSE,
    operationDetails = "string",
    operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
    status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
    statusChangedAt = as.POSIXct(
      "2015-01-01"
    ),
    errorCode = "string",
    errorDetails = "string"
  )
)
}
}
\description{
Attaches an SSL/TLS certificate to your Amazon Lightsail content
delivery network (CDN) distribution.

After the certificate is attached, your distribution accepts HTTPS
traffic for all of the domains that are associated with the certificate.

Use the \code{\link[=lightsail_create_certificate]{create_certificate}} action to
create a certificate that you can attach to your distribution.

Only certificates created in the \code{us-east-1} AWS Region can be attached
to Lightsail distributions. Lightsail distributions are global resources
that can reference an origin in any AWS Region, and distribute its
content globally. However, all distributions are located in the
\code{us-east-1} Region.
}
\section{Request syntax}{
\preformatted{svc$attach_certificate_to_distribution(
  distributionName = "string",
  certificateName = "string"
)
}
}

\keyword{internal}
