% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_queued_reserved_instances}
\alias{ec2_delete_queued_reserved_instances}
\title{Deletes the queued purchases for the specified Reserved Instances}
\usage{
ec2_delete_queued_reserved_instances(DryRun, ReservedInstancesIds)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ReservedInstancesIds}{[required] The IDs of the Reserved Instances.}
}
\value{
A list with the following syntax:\preformatted{list(
  SuccessfulQueuedPurchaseDeletions = list(
    list(
      ReservedInstancesId = "string"
    )
  ),
  FailedQueuedPurchaseDeletions = list(
    list(
      Error = list(
        Code = "reserved-instances-id-invalid"|"reserved-instances-not-in-queued-state"|"unexpected-error",
        Message = "string"
      ),
      ReservedInstancesId = "string"
    )
  )
)
}
}
\description{
Deletes the queued purchases for the specified Reserved Instances.
}
\section{Request syntax}{
\preformatted{svc$delete_queued_reserved_instances(
  DryRun = TRUE|FALSE,
  ReservedInstancesIds = list(
    "string"
  )
)
}
}

\keyword{internal}
