% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_create_code_signing_config}
\alias{lambda_create_code_signing_config}
\title{Creates a code signing configuration}
\usage{
lambda_create_code_signing_config(Description, AllowedPublishers,
  CodeSigningPolicies)
}
\arguments{
\item{Description}{Descriptive name for this code signing configuration.}

\item{AllowedPublishers}{[required] Signing profiles for this code signing configuration.}

\item{CodeSigningPolicies}{The code signing policies define the actions to take if the validation
checks fail.}
}
\description{
Creates a code signing configuration. A \href{https://docs.aws.amazon.com/lambda/latest/dg/}{code signing configuration} defines a
list of allowed signing profiles and defines the code-signing validation
policy (action to be taken if deployment validation checks fail).
}
\section{Request syntax}{
\preformatted{svc$create_code_signing_config(
  Description = "string",
  AllowedPublishers = list(
    SigningProfileVersionArns = list(
      "string"
    )
  ),
  CodeSigningPolicies = list(
    UntrustedArtifactOnDeployment = "Warn"|"Enforce"
  )
)
}
}

\keyword{internal}
