% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_describe_configuration_settings}
\alias{elasticbeanstalk_describe_configuration_settings}
\title{Returns a description of the settings for the specified configuration
set, that is, either a configuration template or the configuration set
associated with a running environment}
\usage{
elasticbeanstalk_describe_configuration_settings(ApplicationName,
  TemplateName, EnvironmentName)
}
\arguments{
\item{ApplicationName}{[required] The application for the environment or configuration template.}

\item{TemplateName}{The name of the configuration template to describe.

Conditional: You must specify either this parameter or an
EnvironmentName, but not both. If you specify both, AWS Elastic
Beanstalk returns an \code{InvalidParameterCombination} error. If you do not
specify either, AWS Elastic Beanstalk returns a
\code{MissingRequiredParameter} error.}

\item{EnvironmentName}{The name of the environment to describe.

Condition: You must specify either this or a TemplateName, but not both.
If you specify both, AWS Elastic Beanstalk returns an
\code{InvalidParameterCombination} error. If you do not specify either, AWS
Elastic Beanstalk returns \code{MissingRequiredParameter} error.}
}
\description{
Returns a description of the settings for the specified configuration
set, that is, either a configuration template or the configuration set
associated with a running environment.

When describing the settings for the configuration set associated with a
running environment, it is possible to receive two sets of setting
descriptions. One is the deployed configuration set, and the other is a
draft configuration of an environment that is either in the process of
deployment or that failed to deploy.

Related Topics
\itemize{
\item DeleteEnvironmentConfiguration
}
}
\section{Request syntax}{
\preformatted{svc$describe_configuration_settings(
  ApplicationName = "string",
  TemplateName = "string",
  EnvironmentName = "string"
)
}
}

\examples{
\dontrun{
# The following operation retrieves configuration settings for an
# environment named my-env:
svc$describe_configuration_settings(
  ApplicationName = "my-app",
  EnvironmentName = "my-env"
)
}

}
\keyword{internal}
