% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mwaa_operations.R
\name{mwaa_update_environment}
\alias{mwaa_update_environment}
\title{Updates an Amazon Managed Workflows for Apache Airflow (MWAA)
environment}
\usage{
mwaa_update_environment(
  AirflowConfigurationOptions = NULL,
  AirflowVersion = NULL,
  DagS3Path = NULL,
  EnvironmentClass = NULL,
  ExecutionRoleArn = NULL,
  LoggingConfiguration = NULL,
  MaxWorkers = NULL,
  MinWorkers = NULL,
  Name,
  NetworkConfiguration = NULL,
  PluginsS3ObjectVersion = NULL,
  PluginsS3Path = NULL,
  RequirementsS3ObjectVersion = NULL,
  RequirementsS3Path = NULL,
  Schedulers = NULL,
  SourceBucketArn = NULL,
  WebserverAccessMode = NULL,
  WeeklyMaintenanceWindowStart = NULL
)
}
\arguments{
\item{AirflowConfigurationOptions}{A list of key-value pairs containing the Apache Airflow configuration
options you want to attach to your environment. To learn more, see
\href{https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html}{Apache Airflow configuration options}.}

\item{AirflowVersion}{The Apache Airflow version for your environment. If no value is
specified, defaults to the latest version. Valid values: \verb{1.10.12},
\verb{2.0.2}, and \verb{2.2.2}.}

\item{DagS3Path}{The relative path to the DAGs folder on your Amazon S3 bucket. For
example, \code{dags}. To learn more, see \href{https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html}{Adding or updating DAGs}.}

\item{EnvironmentClass}{The environment class type. Valid values: \code{mw1.small}, \code{mw1.medium},
\code{mw1.large}. To learn more, see \href{https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html}{Amazon MWAA environment class}.}

\item{ExecutionRoleArn}{The Amazon Resource Name (ARN) of the execution role in IAM that allows
MWAA to access Amazon Web Services resources in your environment. For
example, \verb{arn:aws:iam::123456789:role/my-execution-role}. To learn more,
see \href{https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html}{Amazon MWAA Execution role}.}

\item{LoggingConfiguration}{The Apache Airflow log types to send to CloudWatch Logs.}

\item{MaxWorkers}{The maximum number of workers that you want to run in your environment.
MWAA scales the number of Apache Airflow workers up to the number you
specify in the \code{MaxWorkers} field. For example, \code{20}. When there are no
more tasks running, and no more in the queue, MWAA disposes of the extra
workers leaving the one worker that is included with your environment,
or the number you specify in \code{MinWorkers}.}

\item{MinWorkers}{The minimum number of workers that you want to run in your environment.
MWAA scales the number of Apache Airflow workers up to the number you
specify in the \code{MaxWorkers} field. When there are no more tasks running,
and no more in the queue, MWAA disposes of the extra workers leaving the
worker count you specify in the \code{MinWorkers} field. For example, \code{2}.}

\item{Name}{[required] The name of your Amazon MWAA environment. For example,
\code{MyMWAAEnvironment}.}

\item{NetworkConfiguration}{The VPC networking components used to secure and enable network traffic
between the Amazon Web Services resources for your environment. To learn
more, see \href{https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html}{About networking on Amazon MWAA}.}

\item{PluginsS3ObjectVersion}{The version of the plugins.zip file on your Amazon S3 bucket. A version
must be specified each time a plugins.zip file is updated. To learn
more, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html}{How S3 Versioning works}.}

\item{PluginsS3Path}{The relative path to the \code{plugins.zip} file on your Amazon S3 bucket.
For example, \code{plugins.zip}. If specified, then the plugins.zip version
is required. To learn more, see \href{https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html}{Installing custom plugins}.}

\item{RequirementsS3ObjectVersion}{The version of the requirements.txt file on your Amazon S3 bucket. A
version must be specified each time a requirements.txt file is updated.
To learn more, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html}{How S3 Versioning works}.}

\item{RequirementsS3Path}{The relative path to the \code{requirements.txt} file on your Amazon S3
bucket. For example, \code{requirements.txt}. If specified, then a file
version is required. To learn more, see \href{https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html}{Installing Python dependencies}.}

\item{Schedulers}{The number of Apache Airflow schedulers to run in your Amazon MWAA
environment.}

\item{SourceBucketArn}{The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG
code and supporting files are stored. For example,
\code{arn:aws:s3:::my-airflow-bucket-unique-name}. To learn more, see \href{https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html}{Create an Amazon S3 bucket for Amazon MWAA}.}

\item{WebserverAccessMode}{The Apache Airflow \emph{Web server} access mode. To learn more, see \href{https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html}{Apache Airflow access modes}.}

\item{WeeklyMaintenanceWindowStart}{The day and time of the week in Coordinated Universal Time (UTC) 24-hour
standard time to start weekly maintenance updates of your environment in
the following format: \code{DAY:HH:MM}. For example: \code{TUE:03:30}. You can
specify a start time in 30 minute increments only.}
}
\description{
Updates an Amazon Managed Workflows for Apache Airflow (MWAA) environment.

See \url{https://paws-r.github.io/docs/mwaa/update_environment.html} for full documentation.
}
\keyword{internal}
