# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ivsrealtime_service.R
NULL

#' Creates an EncoderConfiguration object
#'
#' @description
#' Creates an EncoderConfiguration object.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_create_encoder_configuration/](https://www.paws-r-sdk.com/docs/ivsrealtime_create_encoder_configuration/) for full documentation.
#'
#' @param name Optional name to identify the resource.
#' @param video Video configuration. Default: video resolution 1280x720, bitrate 2500
#' kbps, 30 fps.
#' @param tags Tags attached to the resource. Array of maps, each of the form
#' `string:string (key:value)`. See [Best practices and
#' strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html)
#' in *Tagging AWS Resources and Tag Editor* for details, including
#' restrictions that apply to tags and "Tag naming limits and
#' requirements"; Amazon IVS has no constraints on tags beyond what is
#' documented there.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_create_encoder_configuration
ivsrealtime_create_encoder_configuration <- function(name = NULL, video = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateEncoderConfiguration",
    http_method = "POST",
    http_path = "/CreateEncoderConfiguration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$create_encoder_configuration_input(name = name, video = video, tags = tags)
  output <- .ivsrealtime$create_encoder_configuration_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$create_encoder_configuration <- ivsrealtime_create_encoder_configuration

#' Creates a new IngestConfiguration resource, used to specify the ingest
#' protocol for a stage
#'
#' @description
#' Creates a new IngestConfiguration resource, used to specify the ingest protocol for a stage.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_create_ingest_configuration/](https://www.paws-r-sdk.com/docs/ivsrealtime_create_ingest_configuration/) for full documentation.
#'
#' @param name Optional name that can be specified for the IngestConfiguration being
#' created.
#' @param stageArn ARN of the stage with which the IngestConfiguration is associated.
#' @param userId Customer-assigned name to help identify the participant using the
#' IngestConfiguration; this can be used to link a participant to a user in
#' the customer’s own systems. This can be any UTF-8 encoded text. *This
#' field is exposed to all stage participants and should not be used for
#' personally identifying, confidential, or sensitive information.*
#' @param attributes Application-provided attributes to store in the IngestConfiguration and
#' attach to a stage. Map keys and values can contain UTF-8 encoded text.
#' The maximum length of this field is 1 KB total. *This field is exposed
#' to all stage participants and should not be used for personally
#' identifying, confidential, or sensitive information.*
#' @param ingestProtocol &#91;required&#93; Type of ingest protocol that the user employs to broadcast. If this is
#' set to `RTMP`, `insecureIngest` must be set to `true`.
#' @param insecureIngest Whether the stage allows insecure RTMP ingest. This must be set to
#' `true`, if `ingestProtocol` is set to `RTMP`. Default: `false`.
#' @param tags Tags attached to the resource. Array of maps, each of the form
#' `string:string (key:value)`. See [Best practices and
#' strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html)
#' in *Tagging AWS Resources and Tag Editor* for details, including
#' restrictions that apply to tags and "Tag naming limits and
#' requirements"; Amazon IVS has no constraints on tags beyond what is
#' documented there.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_create_ingest_configuration
ivsrealtime_create_ingest_configuration <- function(name = NULL, stageArn = NULL, userId = NULL, attributes = NULL, ingestProtocol, insecureIngest = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateIngestConfiguration",
    http_method = "POST",
    http_path = "/CreateIngestConfiguration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$create_ingest_configuration_input(name = name, stageArn = stageArn, userId = userId, attributes = attributes, ingestProtocol = ingestProtocol, insecureIngest = insecureIngest, tags = tags)
  output <- .ivsrealtime$create_ingest_configuration_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$create_ingest_configuration <- ivsrealtime_create_ingest_configuration

#' Creates an additional token for a specified stage
#'
#' @description
#' Creates an additional token for a specified stage. This can be done after stage creation or when tokens expire. Tokens always are scoped to the stage for which they are created.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_create_participant_token/](https://www.paws-r-sdk.com/docs/ivsrealtime_create_participant_token/) for full documentation.
#'
#' @param stageArn &#91;required&#93; ARN of the stage to which this token is scoped.
#' @param duration Duration (in minutes), after which the token expires. Default: 720 (12
#' hours).
#' @param userId Name that can be specified to help identify the token. This can be any
#' UTF-8 encoded text. *This field is exposed to all stage participants and
#' should not be used for personally identifying, confidential, or
#' sensitive information.*
#' @param attributes Application-provided attributes to encode into the token and attach to a
#' stage. Map keys and values can contain UTF-8 encoded text. The maximum
#' length of this field is 1 KB total. *This field is exposed to all stage
#' participants and should not be used for personally identifying,
#' confidential, or sensitive information.*
#' @param capabilities Set of capabilities that the user is allowed to perform in the stage.
#' Default: `PUBLISH, SUBSCRIBE`.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_create_participant_token
ivsrealtime_create_participant_token <- function(stageArn, duration = NULL, userId = NULL, attributes = NULL, capabilities = NULL) {
  op <- new_operation(
    name = "CreateParticipantToken",
    http_method = "POST",
    http_path = "/CreateParticipantToken",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$create_participant_token_input(stageArn = stageArn, duration = duration, userId = userId, attributes = attributes, capabilities = capabilities)
  output <- .ivsrealtime$create_participant_token_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$create_participant_token <- ivsrealtime_create_participant_token

#' Creates a new stage (and optionally participant tokens)
#'
#' @description
#' Creates a new stage (and optionally participant tokens).
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_create_stage/](https://www.paws-r-sdk.com/docs/ivsrealtime_create_stage/) for full documentation.
#'
#' @param name Optional name that can be specified for the stage being created.
#' @param participantTokenConfigurations Array of participant token configuration objects to attach to the new
#' stage.
#' @param tags Tags attached to the resource. Array of maps, each of the form
#' `string:string (key:value)`. See [Best practices and
#' strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html)
#' in *Tagging AWS Resources and Tag Editor* for details, including
#' restrictions that apply to tags and "Tag naming limits and
#' requirements"; Amazon IVS has no constraints on tags beyond what is
#' documented there.
#' @param autoParticipantRecordingConfiguration Configuration object for individual participant recording, to attach to
#' the new stage.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_create_stage
ivsrealtime_create_stage <- function(name = NULL, participantTokenConfigurations = NULL, tags = NULL, autoParticipantRecordingConfiguration = NULL) {
  op <- new_operation(
    name = "CreateStage",
    http_method = "POST",
    http_path = "/CreateStage",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$create_stage_input(name = name, participantTokenConfigurations = participantTokenConfigurations, tags = tags, autoParticipantRecordingConfiguration = autoParticipantRecordingConfiguration)
  output <- .ivsrealtime$create_stage_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$create_stage <- ivsrealtime_create_stage

#' Creates a new storage configuration, used to enable recording to Amazon
#' S3
#'
#' @description
#' Creates a new storage configuration, used to enable recording to Amazon S3. When a StorageConfiguration is created, IVS will modify the S3 bucketPolicy of the provided bucket. This will ensure that IVS has sufficient permissions to write content to the provided bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_create_storage_configuration/](https://www.paws-r-sdk.com/docs/ivsrealtime_create_storage_configuration/) for full documentation.
#'
#' @param name Storage configuration name. The value does not need to be unique.
#' @param s3 &#91;required&#93; A complex type that contains a storage configuration for where recorded
#' video will be stored.
#' @param tags Tags attached to the resource. Array of maps, each of the form
#' `string:string (key:value)`. See [Best practices and
#' strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html)
#' in *Tagging AWS Resources and Tag Editor* for details, including
#' restrictions that apply to tags and "Tag naming limits and
#' requirements"; Amazon IVS has no constraints on tags beyond what is
#' documented there.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_create_storage_configuration
ivsrealtime_create_storage_configuration <- function(name = NULL, s3, tags = NULL) {
  op <- new_operation(
    name = "CreateStorageConfiguration",
    http_method = "POST",
    http_path = "/CreateStorageConfiguration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$create_storage_configuration_input(name = name, s3 = s3, tags = tags)
  output <- .ivsrealtime$create_storage_configuration_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$create_storage_configuration <- ivsrealtime_create_storage_configuration

#' Deletes an EncoderConfiguration resource
#'
#' @description
#' Deletes an EncoderConfiguration resource. Ensures that no Compositions are using this template; otherwise, returns an error.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_delete_encoder_configuration/](https://www.paws-r-sdk.com/docs/ivsrealtime_delete_encoder_configuration/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the EncoderConfiguration.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_delete_encoder_configuration
ivsrealtime_delete_encoder_configuration <- function(arn) {
  op <- new_operation(
    name = "DeleteEncoderConfiguration",
    http_method = "POST",
    http_path = "/DeleteEncoderConfiguration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$delete_encoder_configuration_input(arn = arn)
  output <- .ivsrealtime$delete_encoder_configuration_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$delete_encoder_configuration <- ivsrealtime_delete_encoder_configuration

#' Deletes a specified IngestConfiguration, so it can no longer be used to
#' broadcast
#'
#' @description
#' Deletes a specified IngestConfiguration, so it can no longer be used to broadcast. An IngestConfiguration cannot be deleted if the publisher is actively streaming to a stage, unless `force` is set to `true`.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_delete_ingest_configuration/](https://www.paws-r-sdk.com/docs/ivsrealtime_delete_ingest_configuration/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the IngestConfiguration.
#' @param force Optional field to force deletion of the IngestConfiguration. If this is
#' set to `true` when a participant is actively publishing, the participant
#' is disconnected from the stage, followed by deletion of the
#' IngestConfiguration. Default: `false`.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_delete_ingest_configuration
ivsrealtime_delete_ingest_configuration <- function(arn, force = NULL) {
  op <- new_operation(
    name = "DeleteIngestConfiguration",
    http_method = "POST",
    http_path = "/DeleteIngestConfiguration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$delete_ingest_configuration_input(arn = arn, force = force)
  output <- .ivsrealtime$delete_ingest_configuration_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$delete_ingest_configuration <- ivsrealtime_delete_ingest_configuration

#' Deletes the specified public key used to sign stage participant tokens
#'
#' @description
#' Deletes the specified public key used to sign stage participant tokens. This invalidates future participant tokens generated using the key pair’s private key.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_delete_public_key/](https://www.paws-r-sdk.com/docs/ivsrealtime_delete_public_key/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the public key to be deleted.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_delete_public_key
ivsrealtime_delete_public_key <- function(arn) {
  op <- new_operation(
    name = "DeletePublicKey",
    http_method = "POST",
    http_path = "/DeletePublicKey",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$delete_public_key_input(arn = arn)
  output <- .ivsrealtime$delete_public_key_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$delete_public_key <- ivsrealtime_delete_public_key

#' Shuts down and deletes the specified stage (disconnecting all
#' participants)
#'
#' @description
#' Shuts down and deletes the specified stage (disconnecting all participants). This operation also removes the `stageArn` from the associated IngestConfiguration, if there are participants using the IngestConfiguration to publish to the stage.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_delete_stage/](https://www.paws-r-sdk.com/docs/ivsrealtime_delete_stage/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the stage to be deleted.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_delete_stage
ivsrealtime_delete_stage <- function(arn) {
  op <- new_operation(
    name = "DeleteStage",
    http_method = "POST",
    http_path = "/DeleteStage",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$delete_stage_input(arn = arn)
  output <- .ivsrealtime$delete_stage_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$delete_stage <- ivsrealtime_delete_stage

#' Deletes the storage configuration for the specified ARN
#'
#' @description
#' Deletes the storage configuration for the specified ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_delete_storage_configuration/](https://www.paws-r-sdk.com/docs/ivsrealtime_delete_storage_configuration/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the storage configuration to be deleted.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_delete_storage_configuration
ivsrealtime_delete_storage_configuration <- function(arn) {
  op <- new_operation(
    name = "DeleteStorageConfiguration",
    http_method = "POST",
    http_path = "/DeleteStorageConfiguration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$delete_storage_configuration_input(arn = arn)
  output <- .ivsrealtime$delete_storage_configuration_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$delete_storage_configuration <- ivsrealtime_delete_storage_configuration

#' Disconnects a specified participant from a specified stage
#'
#' @description
#' Disconnects a specified participant from a specified stage. If the participant is publishing using an IngestConfiguration, DisconnectParticipant also updates the `stageArn` in the IngestConfiguration to be an empty string.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_disconnect_participant/](https://www.paws-r-sdk.com/docs/ivsrealtime_disconnect_participant/) for full documentation.
#'
#' @param stageArn &#91;required&#93; ARN of the stage to which the participant is attached.
#' @param participantId &#91;required&#93; Identifier of the participant to be disconnected. IVS assigns this; it
#' is returned by
#' [`create_participant_token`][ivsrealtime_create_participant_token] (for
#' streams using WebRTC ingest) or
#' [`create_ingest_configuration`][ivsrealtime_create_ingest_configuration]
#' (for streams using RTMP ingest).
#' @param reason Description of why this participant is being disconnected.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_disconnect_participant
ivsrealtime_disconnect_participant <- function(stageArn, participantId, reason = NULL) {
  op <- new_operation(
    name = "DisconnectParticipant",
    http_method = "POST",
    http_path = "/DisconnectParticipant",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$disconnect_participant_input(stageArn = stageArn, participantId = participantId, reason = reason)
  output <- .ivsrealtime$disconnect_participant_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$disconnect_participant <- ivsrealtime_disconnect_participant

#' Get information about the specified Composition resource
#'
#' @description
#' Get information about the specified Composition resource.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_get_composition/](https://www.paws-r-sdk.com/docs/ivsrealtime_get_composition/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the Composition resource.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_get_composition
ivsrealtime_get_composition <- function(arn) {
  op <- new_operation(
    name = "GetComposition",
    http_method = "POST",
    http_path = "/GetComposition",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$get_composition_input(arn = arn)
  output <- .ivsrealtime$get_composition_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$get_composition <- ivsrealtime_get_composition

#' Gets information about the specified EncoderConfiguration resource
#'
#' @description
#' Gets information about the specified EncoderConfiguration resource.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_get_encoder_configuration/](https://www.paws-r-sdk.com/docs/ivsrealtime_get_encoder_configuration/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the EncoderConfiguration resource.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_get_encoder_configuration
ivsrealtime_get_encoder_configuration <- function(arn) {
  op <- new_operation(
    name = "GetEncoderConfiguration",
    http_method = "POST",
    http_path = "/GetEncoderConfiguration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$get_encoder_configuration_input(arn = arn)
  output <- .ivsrealtime$get_encoder_configuration_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$get_encoder_configuration <- ivsrealtime_get_encoder_configuration

#' Gets information about the specified IngestConfiguration
#'
#' @description
#' Gets information about the specified IngestConfiguration.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_get_ingest_configuration/](https://www.paws-r-sdk.com/docs/ivsrealtime_get_ingest_configuration/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the ingest for which the information is to be retrieved.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_get_ingest_configuration
ivsrealtime_get_ingest_configuration <- function(arn) {
  op <- new_operation(
    name = "GetIngestConfiguration",
    http_method = "POST",
    http_path = "/GetIngestConfiguration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$get_ingest_configuration_input(arn = arn)
  output <- .ivsrealtime$get_ingest_configuration_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$get_ingest_configuration <- ivsrealtime_get_ingest_configuration

#' Gets information about the specified participant token
#'
#' @description
#' Gets information about the specified participant token.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_get_participant/](https://www.paws-r-sdk.com/docs/ivsrealtime_get_participant/) for full documentation.
#'
#' @param stageArn &#91;required&#93; Stage ARN.
#' @param sessionId &#91;required&#93; ID of a session within the stage.
#' @param participantId &#91;required&#93; Unique identifier for the participant. This is assigned by IVS and
#' returned by
#' [`create_participant_token`][ivsrealtime_create_participant_token].
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_get_participant
ivsrealtime_get_participant <- function(stageArn, sessionId, participantId) {
  op <- new_operation(
    name = "GetParticipant",
    http_method = "POST",
    http_path = "/GetParticipant",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$get_participant_input(stageArn = stageArn, sessionId = sessionId, participantId = participantId)
  output <- .ivsrealtime$get_participant_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$get_participant <- ivsrealtime_get_participant

#' Gets information for the specified public key
#'
#' @description
#' Gets information for the specified public key.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_get_public_key/](https://www.paws-r-sdk.com/docs/ivsrealtime_get_public_key/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the public key for which the information is to be retrieved.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_get_public_key
ivsrealtime_get_public_key <- function(arn) {
  op <- new_operation(
    name = "GetPublicKey",
    http_method = "POST",
    http_path = "/GetPublicKey",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$get_public_key_input(arn = arn)
  output <- .ivsrealtime$get_public_key_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$get_public_key <- ivsrealtime_get_public_key

#' Gets information for the specified stage
#'
#' @description
#' Gets information for the specified stage.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_get_stage/](https://www.paws-r-sdk.com/docs/ivsrealtime_get_stage/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the stage for which the information is to be retrieved.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_get_stage
ivsrealtime_get_stage <- function(arn) {
  op <- new_operation(
    name = "GetStage",
    http_method = "POST",
    http_path = "/GetStage",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$get_stage_input(arn = arn)
  output <- .ivsrealtime$get_stage_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$get_stage <- ivsrealtime_get_stage

#' Gets information for the specified stage session
#'
#' @description
#' Gets information for the specified stage session.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_get_stage_session/](https://www.paws-r-sdk.com/docs/ivsrealtime_get_stage_session/) for full documentation.
#'
#' @param stageArn &#91;required&#93; ARN of the stage for which the information is to be retrieved.
#' @param sessionId &#91;required&#93; ID of a session within the stage.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_get_stage_session
ivsrealtime_get_stage_session <- function(stageArn, sessionId) {
  op <- new_operation(
    name = "GetStageSession",
    http_method = "POST",
    http_path = "/GetStageSession",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$get_stage_session_input(stageArn = stageArn, sessionId = sessionId)
  output <- .ivsrealtime$get_stage_session_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$get_stage_session <- ivsrealtime_get_stage_session

#' Gets the storage configuration for the specified ARN
#'
#' @description
#' Gets the storage configuration for the specified ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_get_storage_configuration/](https://www.paws-r-sdk.com/docs/ivsrealtime_get_storage_configuration/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the storage configuration to be retrieved.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_get_storage_configuration
ivsrealtime_get_storage_configuration <- function(arn) {
  op <- new_operation(
    name = "GetStorageConfiguration",
    http_method = "POST",
    http_path = "/GetStorageConfiguration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$get_storage_configuration_input(arn = arn)
  output <- .ivsrealtime$get_storage_configuration_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$get_storage_configuration <- ivsrealtime_get_storage_configuration

#' Import a public key to be used for signing stage participant tokens
#'
#' @description
#' Import a public key to be used for signing stage participant tokens.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_import_public_key/](https://www.paws-r-sdk.com/docs/ivsrealtime_import_public_key/) for full documentation.
#'
#' @param publicKeyMaterial &#91;required&#93; The content of the public key to be imported.
#' @param name Name of the public key to be imported.
#' @param tags Tags attached to the resource. Array of maps, each of the form
#' `string:string (key:value)`. See [Best practices and
#' strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html)
#' in *Tagging AWS Resources and Tag Editor* for details, including
#' restrictions that apply to tags and "Tag naming limits and
#' requirements"; Amazon IVS has no constraints on tags beyond what is
#' documented there.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_import_public_key
ivsrealtime_import_public_key <- function(publicKeyMaterial, name = NULL, tags = NULL) {
  op <- new_operation(
    name = "ImportPublicKey",
    http_method = "POST",
    http_path = "/ImportPublicKey",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$import_public_key_input(publicKeyMaterial = publicKeyMaterial, name = name, tags = tags)
  output <- .ivsrealtime$import_public_key_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$import_public_key <- ivsrealtime_import_public_key

#' Gets summary information about all Compositions in your account, in the
#' AWS region where the API request is processed
#'
#' @description
#' Gets summary information about all Compositions in your account, in the AWS region where the API request is processed.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_list_compositions/](https://www.paws-r-sdk.com/docs/ivsrealtime_list_compositions/) for full documentation.
#'
#' @param filterByStageArn Filters the Composition list to match the specified Stage ARN.
#' @param filterByEncoderConfigurationArn Filters the Composition list to match the specified EncoderConfiguration
#' attached to at least one of its output.
#' @param nextToken The first Composition to retrieve. This is used for pagination; see the
#' `nextToken` response field.
#' @param maxResults Maximum number of results to return. Default: 100.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_list_compositions
ivsrealtime_list_compositions <- function(filterByStageArn = NULL, filterByEncoderConfigurationArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListCompositions",
    http_method = "POST",
    http_path = "/ListCompositions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .ivsrealtime$list_compositions_input(filterByStageArn = filterByStageArn, filterByEncoderConfigurationArn = filterByEncoderConfigurationArn, nextToken = nextToken, maxResults = maxResults)
  output <- .ivsrealtime$list_compositions_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$list_compositions <- ivsrealtime_list_compositions

#' Gets summary information about all EncoderConfigurations in your
#' account, in the AWS region where the API request is processed
#'
#' @description
#' Gets summary information about all EncoderConfigurations in your account, in the AWS region where the API request is processed.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_list_encoder_configurations/](https://www.paws-r-sdk.com/docs/ivsrealtime_list_encoder_configurations/) for full documentation.
#'
#' @param nextToken The first encoder configuration to retrieve. This is used for
#' pagination; see the `nextToken` response field.
#' @param maxResults Maximum number of results to return. Default: 100.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_list_encoder_configurations
ivsrealtime_list_encoder_configurations <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListEncoderConfigurations",
    http_method = "POST",
    http_path = "/ListEncoderConfigurations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .ivsrealtime$list_encoder_configurations_input(nextToken = nextToken, maxResults = maxResults)
  output <- .ivsrealtime$list_encoder_configurations_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$list_encoder_configurations <- ivsrealtime_list_encoder_configurations

#' Lists all IngestConfigurations in your account, in the AWS region where
#' the API request is processed
#'
#' @description
#' Lists all IngestConfigurations in your account, in the AWS region where the API request is processed.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_list_ingest_configurations/](https://www.paws-r-sdk.com/docs/ivsrealtime_list_ingest_configurations/) for full documentation.
#'
#' @param filterByStageArn Filters the response list to match the specified stage ARN. Only one
#' filter (by stage ARN or by state) can be used at a time.
#' @param filterByState Filters the response list to match the specified state. Only one filter
#' (by stage ARN or by state) can be used at a time.
#' @param nextToken The first IngestConfiguration to retrieve. This is used for pagination;
#' see the `nextToken` response field.
#' @param maxResults Maximum number of results to return. Default: 50.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_list_ingest_configurations
ivsrealtime_list_ingest_configurations <- function(filterByStageArn = NULL, filterByState = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListIngestConfigurations",
    http_method = "POST",
    http_path = "/ListIngestConfigurations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "ingestConfigurations"),
    stream_api = FALSE
  )
  input <- .ivsrealtime$list_ingest_configurations_input(filterByStageArn = filterByStageArn, filterByState = filterByState, nextToken = nextToken, maxResults = maxResults)
  output <- .ivsrealtime$list_ingest_configurations_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$list_ingest_configurations <- ivsrealtime_list_ingest_configurations

#' Lists events for a specified participant that occurred during a
#' specified stage session
#'
#' @description
#' Lists events for a specified participant that occurred during a specified stage session.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_list_participant_events/](https://www.paws-r-sdk.com/docs/ivsrealtime_list_participant_events/) for full documentation.
#'
#' @param stageArn &#91;required&#93; Stage ARN.
#' @param sessionId &#91;required&#93; ID of a session within the stage.
#' @param participantId &#91;required&#93; Unique identifier for this participant. This is assigned by IVS and
#' returned by
#' [`create_participant_token`][ivsrealtime_create_participant_token].
#' @param nextToken The first participant event to retrieve. This is used for pagination;
#' see the `nextToken` response field.
#' @param maxResults Maximum number of results to return. Default: 50.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_list_participant_events
ivsrealtime_list_participant_events <- function(stageArn, sessionId, participantId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListParticipantEvents",
    http_method = "POST",
    http_path = "/ListParticipantEvents",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .ivsrealtime$list_participant_events_input(stageArn = stageArn, sessionId = sessionId, participantId = participantId, nextToken = nextToken, maxResults = maxResults)
  output <- .ivsrealtime$list_participant_events_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$list_participant_events <- ivsrealtime_list_participant_events

#' Lists all participants in a specified stage session
#'
#' @description
#' Lists all participants in a specified stage session.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_list_participants/](https://www.paws-r-sdk.com/docs/ivsrealtime_list_participants/) for full documentation.
#'
#' @param stageArn &#91;required&#93; Stage ARN.
#' @param sessionId &#91;required&#93; ID of the session within the stage.
#' @param filterByUserId Filters the response list to match the specified user ID. Only one of
#' `filterByUserId`, `filterByPublished`, `filterByState`, or
#' `filterByRecordingState` can be provided per request. A `userId` is a
#' customer-assigned name to help identify the token; this can be used to
#' link a participant to a user in the customer’s own systems.
#' @param filterByPublished Filters the response list to only show participants who published during
#' the stage session. Only one of `filterByUserId`, `filterByPublished`,
#' `filterByState`, or `filterByRecordingState` can be provided per
#' request.
#' @param filterByState Filters the response list to only show participants in the specified
#' state. Only one of `filterByUserId`, `filterByPublished`,
#' `filterByState`, or `filterByRecordingState` can be provided per
#' request.
#' @param nextToken The first participant to retrieve. This is used for pagination; see the
#' `nextToken` response field.
#' @param maxResults Maximum number of results to return. Default: 50.
#' @param filterByRecordingState Filters the response list to only show participants with the specified
#' recording state. Only one of `filterByUserId`, `filterByPublished`,
#' `filterByState`, or `filterByRecordingState` can be provided per
#' request.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_list_participants
ivsrealtime_list_participants <- function(stageArn, sessionId, filterByUserId = NULL, filterByPublished = NULL, filterByState = NULL, nextToken = NULL, maxResults = NULL, filterByRecordingState = NULL) {
  op <- new_operation(
    name = "ListParticipants",
    http_method = "POST",
    http_path = "/ListParticipants",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .ivsrealtime$list_participants_input(stageArn = stageArn, sessionId = sessionId, filterByUserId = filterByUserId, filterByPublished = filterByPublished, filterByState = filterByState, nextToken = nextToken, maxResults = maxResults, filterByRecordingState = filterByRecordingState)
  output <- .ivsrealtime$list_participants_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$list_participants <- ivsrealtime_list_participants

#' Gets summary information about all public keys in your account, in the
#' AWS region where the API request is processed
#'
#' @description
#' Gets summary information about all public keys in your account, in the AWS region where the API request is processed.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_list_public_keys/](https://www.paws-r-sdk.com/docs/ivsrealtime_list_public_keys/) for full documentation.
#'
#' @param nextToken The first public key to retrieve. This is used for pagination; see the
#' `nextToken` response field.
#' @param maxResults Maximum number of results to return. Default: 50.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_list_public_keys
ivsrealtime_list_public_keys <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListPublicKeys",
    http_method = "POST",
    http_path = "/ListPublicKeys",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "publicKeys"),
    stream_api = FALSE
  )
  input <- .ivsrealtime$list_public_keys_input(nextToken = nextToken, maxResults = maxResults)
  output <- .ivsrealtime$list_public_keys_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$list_public_keys <- ivsrealtime_list_public_keys

#' Gets all sessions for a specified stage
#'
#' @description
#' Gets all sessions for a specified stage.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_list_stage_sessions/](https://www.paws-r-sdk.com/docs/ivsrealtime_list_stage_sessions/) for full documentation.
#'
#' @param stageArn &#91;required&#93; Stage ARN.
#' @param nextToken The first stage session to retrieve. This is used for pagination; see
#' the `nextToken` response field.
#' @param maxResults Maximum number of results to return. Default: 50.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_list_stage_sessions
ivsrealtime_list_stage_sessions <- function(stageArn, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListStageSessions",
    http_method = "POST",
    http_path = "/ListStageSessions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .ivsrealtime$list_stage_sessions_input(stageArn = stageArn, nextToken = nextToken, maxResults = maxResults)
  output <- .ivsrealtime$list_stage_sessions_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$list_stage_sessions <- ivsrealtime_list_stage_sessions

#' Gets summary information about all stages in your account, in the AWS
#' region where the API request is processed
#'
#' @description
#' Gets summary information about all stages in your account, in the AWS region where the API request is processed.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_list_stages/](https://www.paws-r-sdk.com/docs/ivsrealtime_list_stages/) for full documentation.
#'
#' @param nextToken The first stage to retrieve. This is used for pagination; see the
#' `nextToken` response field.
#' @param maxResults Maximum number of results to return. Default: 50.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_list_stages
ivsrealtime_list_stages <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListStages",
    http_method = "POST",
    http_path = "/ListStages",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .ivsrealtime$list_stages_input(nextToken = nextToken, maxResults = maxResults)
  output <- .ivsrealtime$list_stages_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$list_stages <- ivsrealtime_list_stages

#' Gets summary information about all storage configurations in your
#' account, in the AWS region where the API request is processed
#'
#' @description
#' Gets summary information about all storage configurations in your account, in the AWS region where the API request is processed.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_list_storage_configurations/](https://www.paws-r-sdk.com/docs/ivsrealtime_list_storage_configurations/) for full documentation.
#'
#' @param nextToken The first storage configuration to retrieve. This is used for
#' pagination; see the `nextToken` response field.
#' @param maxResults Maximum number of storage configurations to return. Default: your
#' service quota or 100, whichever is smaller.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_list_storage_configurations
ivsrealtime_list_storage_configurations <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListStorageConfigurations",
    http_method = "POST",
    http_path = "/ListStorageConfigurations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .ivsrealtime$list_storage_configurations_input(nextToken = nextToken, maxResults = maxResults)
  output <- .ivsrealtime$list_storage_configurations_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$list_storage_configurations <- ivsrealtime_list_storage_configurations

#' Gets information about AWS tags for the specified ARN
#'
#' @description
#' Gets information about AWS tags for the specified ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/ivsrealtime_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource to be retrieved. The ARN must be URL-encoded.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_list_tags_for_resource
ivsrealtime_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .ivsrealtime$list_tags_for_resource_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$list_tags_for_resource <- ivsrealtime_list_tags_for_resource

#' Starts a Composition from a stage based on the configuration provided in
#' the request
#'
#' @description
#' Starts a Composition from a stage based on the configuration provided in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_start_composition/](https://www.paws-r-sdk.com/docs/ivsrealtime_start_composition/) for full documentation.
#'
#' @param stageArn &#91;required&#93; ARN of the stage to be used for compositing.
#' @param idempotencyToken Idempotency token.
#' @param layout Layout object to configure composition parameters.
#' @param destinations &#91;required&#93; Array of destination configuration.
#' @param tags Tags attached to the resource. Array of maps, each of the form
#' `string:string (key:value)`. See [Best practices and
#' strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html)
#' in *Tagging AWS Resources and Tag Editor* for details, including
#' restrictions that apply to tags and "Tag naming limits and
#' requirements"; Amazon IVS has no constraints on tags beyond what is
#' documented there.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_start_composition
ivsrealtime_start_composition <- function(stageArn, idempotencyToken = NULL, layout = NULL, destinations, tags = NULL) {
  op <- new_operation(
    name = "StartComposition",
    http_method = "POST",
    http_path = "/StartComposition",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$start_composition_input(stageArn = stageArn, idempotencyToken = idempotencyToken, layout = layout, destinations = destinations, tags = tags)
  output <- .ivsrealtime$start_composition_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$start_composition <- ivsrealtime_start_composition

#' Stops and deletes a Composition resource
#'
#' @description
#' Stops and deletes a Composition resource. Any broadcast from the Composition resource is stopped.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_stop_composition/](https://www.paws-r-sdk.com/docs/ivsrealtime_stop_composition/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the Composition.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_stop_composition
ivsrealtime_stop_composition <- function(arn) {
  op <- new_operation(
    name = "StopComposition",
    http_method = "POST",
    http_path = "/StopComposition",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$stop_composition_input(arn = arn)
  output <- .ivsrealtime$stop_composition_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$stop_composition <- ivsrealtime_stop_composition

#' Adds or updates tags for the AWS resource with the specified ARN
#'
#' @description
#' Adds or updates tags for the AWS resource with the specified ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_tag_resource/](https://www.paws-r-sdk.com/docs/ivsrealtime_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource to be tagged. The ARN must be URL-encoded.
#' @param tags &#91;required&#93; Array of tags to be added or updated. Array of maps, each of the form
#' `string:string (key:value)`. See [Best practices and
#' strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html)
#' in *Tagging AWS Resources and Tag Editor* for details, including
#' restrictions that apply to tags and "Tag naming limits and
#' requirements"; Amazon IVS has no constraints on tags beyond what is
#' documented there.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_tag_resource
ivsrealtime_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .ivsrealtime$tag_resource_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$tag_resource <- ivsrealtime_tag_resource

#' Removes tags from the resource with the specified ARN
#'
#' @description
#' Removes tags from the resource with the specified ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_untag_resource/](https://www.paws-r-sdk.com/docs/ivsrealtime_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource to be untagged. The ARN must be URL-encoded.
#' @param tagKeys &#91;required&#93; Array of tags to be removed. Array of maps, each of the form
#' `string:string (key:value)`. See [Best practices and
#' strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html)
#' in *Tagging AWS Resources and Tag Editor* for details, including
#' restrictions that apply to tags and "Tag naming limits and
#' requirements"; Amazon IVS has no constraints on tags beyond what is
#' documented there.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_untag_resource
ivsrealtime_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .ivsrealtime$untag_resource_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$untag_resource <- ivsrealtime_untag_resource

#' Updates a specified IngestConfiguration
#'
#' @description
#' Updates a specified IngestConfiguration. Only the stage ARN attached to the IngestConfiguration can be updated. An IngestConfiguration that is active cannot be updated.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_update_ingest_configuration/](https://www.paws-r-sdk.com/docs/ivsrealtime_update_ingest_configuration/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the IngestConfiguration, for which the related stage ARN needs to
#' be updated.
#' @param stageArn Stage ARN that needs to be updated.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_update_ingest_configuration
ivsrealtime_update_ingest_configuration <- function(arn, stageArn = NULL) {
  op <- new_operation(
    name = "UpdateIngestConfiguration",
    http_method = "POST",
    http_path = "/UpdateIngestConfiguration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$update_ingest_configuration_input(arn = arn, stageArn = stageArn)
  output <- .ivsrealtime$update_ingest_configuration_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$update_ingest_configuration <- ivsrealtime_update_ingest_configuration

#' Updates a stage’s configuration
#'
#' @description
#' Updates a stage’s configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/ivsrealtime_update_stage/](https://www.paws-r-sdk.com/docs/ivsrealtime_update_stage/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the stage to be updated.
#' @param name Name of the stage to be updated.
#' @param autoParticipantRecordingConfiguration Configuration object for individual participant recording, to attach to
#' the stage. Note that this cannot be updated while recording is active.
#'
#' @keywords internal
#'
#' @rdname ivsrealtime_update_stage
ivsrealtime_update_stage <- function(arn, name = NULL, autoParticipantRecordingConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateStage",
    http_method = "POST",
    http_path = "/UpdateStage",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivsrealtime$update_stage_input(arn = arn, name = name, autoParticipantRecordingConfiguration = autoParticipantRecordingConfiguration)
  output <- .ivsrealtime$update_stage_output()
  config <- get_config()
  svc <- .ivsrealtime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivsrealtime$operations$update_stage <- ivsrealtime_update_stage
