# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Kendra Intelligent Ranking
#'
#' @description
#' Amazon Kendra Intelligent Ranking uses Amazon Kendra semantic search
#' capabilities to intelligently re-rank a search service's results.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- kendraranking(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- kendraranking()
#' svc$create_rescore_execution_plan(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=kendraranking_create_rescore_execution_plan]{create_rescore_execution_plan} \tab Creates a rescore execution plan\cr
#'  \link[=kendraranking_delete_rescore_execution_plan]{delete_rescore_execution_plan} \tab Deletes a rescore execution plan\cr
#'  \link[=kendraranking_describe_rescore_execution_plan]{describe_rescore_execution_plan} \tab Gets information about a rescore execution plan\cr
#'  \link[=kendraranking_list_rescore_execution_plans]{list_rescore_execution_plans} \tab Lists your rescore execution plans\cr
#'  \link[=kendraranking_list_tags_for_resource]{list_tags_for_resource} \tab Gets a list of tags associated with a specified resource\cr
#'  \link[=kendraranking_rescore]{rescore} \tab Rescores or re-ranks search results from a search service such as OpenSearch (self managed)\cr
#'  \link[=kendraranking_tag_resource]{tag_resource} \tab Adds a specified tag to a specified rescore execution plan\cr
#'  \link[=kendraranking_untag_resource]{untag_resource} \tab Removes a tag from a rescore execution plan\cr
#'  \link[=kendraranking_update_rescore_execution_plan]{update_rescore_execution_plan} \tab Updates a rescore execution plan
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname kendraranking
#' @export
kendraranking <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .kendraranking$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.kendraranking <- list()

.kendraranking$operations <- list()

.kendraranking$metadata <- list(
  service_name = "kendraranking",
  endpoints = list("*" = list(endpoint = "kendra-ranking.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "kendra-ranking.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "kendra-ranking.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "kendra-ranking.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "kendra-ranking.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "kendra-ranking.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Kendra Ranking",
  api_version = "2022-10-19",
  signing_name = "kendra-ranking",
  json_version = "1.0",
  target_prefix = "AWSKendraRerankingFrontendService"
)

.kendraranking$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.kendraranking$metadata, handlers, config, op)
}
