% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_create_data_source}
\alias{datazone_create_data_source}
\title{Creates an Amazon DataZone data source}
\usage{
datazone_create_data_source(
  assetFormsInput = NULL,
  clientToken = NULL,
  configuration = NULL,
  description = NULL,
  domainIdentifier,
  enableSetting = NULL,
  environmentIdentifier,
  name,
  projectIdentifier,
  publishOnImport = NULL,
  recommendation = NULL,
  schedule = NULL,
  type
)
}
\arguments{
\item{assetFormsInput}{The metadata forms that are to be attached to the assets that this data
source works with.}

\item{clientToken}{A unique, case-sensitive identifier that is provided to ensure the
idempotency of the request.}

\item{configuration}{Specifies the configuration of the data source. It can be set to either
\code{glueRunConfiguration} or \code{redshiftRunConfiguration}.}

\item{description}{The description of the data source.}

\item{domainIdentifier}{[required] The ID of the Amazon DataZone domain where the data source is created.}

\item{enableSetting}{Specifies whether the data source is enabled.}

\item{environmentIdentifier}{[required] The unique identifier of the Amazon DataZone environment to which the
data source publishes assets.}

\item{name}{[required] The name of the data source.}

\item{projectIdentifier}{[required] The identifier of the Amazon DataZone project in which you want to add
this data source.}

\item{publishOnImport}{Specifies whether the assets that this data source creates in the
inventory are to be also automatically published to the catalog.}

\item{recommendation}{Specifies whether the business name generation is to be enabled for this
data source.}

\item{schedule}{The schedule of the data source runs.}

\item{type}{[required] The type of the data source.}
}
\description{
Creates an Amazon DataZone data source.

See \url{https://www.paws-r-sdk.com/docs/datazone_create_data_source/} for full documentation.
}
\keyword{internal}
