% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudsearchdomain_operations.R
\name{cloudsearchdomain_upload_documents}
\alias{cloudsearchdomain_upload_documents}
\title{Posts a batch of documents to a search domain for indexing}
\usage{
cloudsearchdomain_upload_documents(documents, contentType)
}
\arguments{
\item{documents}{[required] A batch of documents formatted in JSON or HTML.}

\item{contentType}{[required] The format of the batch you are uploading. Amazon CloudSearch supports
two document batch formats:
\itemize{
\item application/json
\item application/xml
}}
}
\description{
Posts a batch of documents to a search domain for indexing. A document batch is a collection of add and delete operations that represent the documents you want to add, update, or delete from your domain. Batches can be described in either JSON or XML. Each item that you want Amazon CloudSearch to return as a search result (such as a product) is represented as a document. Every document has a unique ID and one or more fields that contain the data that you want to search and return in results. Individual documents cannot contain more than 1 MB of data. The entire batch cannot exceed 5 MB. To get the best possible upload performance, group add and delete operations in batches that are close the 5 MB limit. Submitting a large volume of single-document batches can overload a domain's document service.

See \url{https://www.paws-r-sdk.com/docs/cloudsearchdomain_upload_documents/} for full documentation.
}
\keyword{internal}
