% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datapipeline_operations.R
\name{datapipeline_report_task_runner_heartbeat}
\alias{datapipeline_report_task_runner_heartbeat}
\title{Task runners call ReportTaskRunnerHeartbeat every 15 minutes to indicate
that they are operational}
\usage{
datapipeline_report_task_runner_heartbeat(
  taskrunnerId,
  workerGroup = NULL,
  hostname = NULL
)
}
\arguments{
\item{taskrunnerId}{[required] The ID of the task runner. This value should be unique across your AWS
account. In the case of AWS Data Pipeline Task Runner launched on a
resource managed by AWS Data Pipeline, the web service provides a unique
identifier when it launches the application. If you have written a
custom task runner, you should assign a unique identifier for the task
runner.}

\item{workerGroup}{The type of task the task runner is configured to accept and process.
The worker group is set as a field on objects in the pipeline when they
are created. You can only specify a single value for \code{workerGroup}.
There are no wildcard values permitted in \code{workerGroup}; the string must
be an exact, case-sensitive, match.}

\item{hostname}{The public DNS name of the task runner.}
}
\description{
Task runners call \code{\link[=datapipeline_report_task_runner_heartbeat]{report_task_runner_heartbeat}} every 15 minutes to indicate that they are operational. If the AWS Data Pipeline Task Runner is launched on a resource managed by AWS Data Pipeline, the web service can use this call to detect when the task runner application has failed and restart a new instance.

See \url{https://www.paws-r-sdk.com/docs/datapipeline_report_task_runner_heartbeat/} for full documentation.
}
\keyword{internal}
