% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_update_data_source}
\alias{kendra_update_data_source}
\title{Updates an existing Amazon Kendra data source}
\usage{
kendra_update_data_source(
  Id,
  Name = NULL,
  IndexId,
  Configuration = NULL,
  Description = NULL,
  Schedule = NULL,
  RoleArn = NULL,
  LanguageCode = NULL,
  CustomDocumentEnrichmentConfiguration = NULL
)
}
\arguments{
\item{Id}{[required] The identifier of the data source you want to update.}

\item{Name}{A new name for the data source connector. You must first delete the data
source and re-create it to change the name of the data source.}

\item{IndexId}{[required] The identifier of the index used with the data source connector.}

\item{Configuration}{Configuration information you want to update for the data source
connector.}

\item{Description}{A new description for the data source connector.}

\item{Schedule}{The sync schedule you want to update for the data source connector.}

\item{RoleArn}{The Amazon Resource Name (ARN) of a role with permission to access the
data source. For more information, see \href{https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html}{IAM Roles for Amazon Kendra}.}

\item{LanguageCode}{The code for a language you want to update for the data source
connector. This allows you to support a language for all documents when
updating the data source. English is supported by default. For more
information on supported languages, including their codes, see \href{https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html}{Adding documents in languages other than English}.}

\item{CustomDocumentEnrichmentConfiguration}{Configuration information you want to update for altering document
metadata and content during the document ingestion process.

For more information on how to create, modify and delete document
metadata, or make other content alterations when you ingest documents
into Amazon Kendra, see \href{https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html}{Customizing document metadata during the ingestion process}.}
}
\description{
Updates an existing Amazon Kendra data source.

See \url{https://paws-r.github.io/docs/kendra/update_data_source.html} for full documentation.
}
\keyword{internal}
