% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalytics_operations.R
\name{kinesisanalytics_tag_resource}
\alias{kinesisanalytics_tag_resource}
\title{Adds one or more key-value tags to a Kinesis Analytics application}
\usage{
kinesisanalytics_tag_resource(ResourceARN, Tags)
}
\arguments{
\item{ResourceARN}{[required] The ARN of the application to assign the tags.}

\item{Tags}{[required] The key-value tags to assign to the application.}
}
\description{
Adds one or more key-value tags to a Kinesis Analytics application. Note
that the maximum number of application tags includes system tags. The
maximum number of user-defined application tags is 50. For more
information, see \href{https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html}{Using Tagging}.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  ResourceARN = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
