% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_create_job}
\alias{glue_create_job}
\title{Creates a new job definition}
\usage{
glue_create_job(Name, Description, LogUri, Role, ExecutionProperty,
  Command, DefaultArguments, Connections, MaxRetries, AllocatedCapacity,
  Timeout, MaxCapacity, SecurityConfiguration, Tags, NotificationProperty,
  GlueVersion, NumberOfWorkers, WorkerType)
}
\arguments{
\item{Name}{[required] The name you assign to this job definition. It must be unique in your
account.}

\item{Description}{Description of the job being defined.}

\item{LogUri}{This field is reserved for future use.}

\item{Role}{[required] The name or Amazon Resource Name (ARN) of the IAM role associated with
this job.}

\item{ExecutionProperty}{An \code{ExecutionProperty} specifying the maximum number of concurrent runs
allowed for this job.}

\item{Command}{[required] The \code{JobCommand} that executes this job.}

\item{DefaultArguments}{The default arguments for this job.

You can specify arguments here that your own job-execution script
consumes, as well as arguments that AWS Glue itself consumes.

For information about how to specify and consume your own Job arguments,
see the \href{https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html}{Calling AWS Glue APIs in Python}
topic in the developer guide.

For information about the key-value pairs that AWS Glue consumes to set
up your job, see the \href{https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html}{Special Parameters Used by AWS Glue}
topic in the developer guide.}

\item{Connections}{The connections used for this job.}

\item{MaxRetries}{The maximum number of times to retry this job if it fails.}

\item{AllocatedCapacity}{This parameter is deprecated. Use \code{MaxCapacity} instead.

The number of AWS Glue data processing units (DPUs) to allocate to this
Job. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a
relative measure of processing power that consists of 4 vCPUs of compute
capacity and 16 GB of memory. For more information, see the \href{https://aws.amazon.com/glue/pricing/}{AWS Glue pricing page}.}

\item{Timeout}{The job timeout in minutes. This is the maximum time that a job run can
consume resources before it is terminated and enters \code{TIMEOUT} status.
The default is 2,880 minutes (48 hours).}

\item{MaxCapacity}{The number of AWS Glue data processing units (DPUs) that can be
allocated when this job runs. A DPU is a relative measure of processing
power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
For more information, see the \href{https://aws.amazon.com/glue/pricing/}{AWS Glue pricing page}.

Do not set \verb{Max Capacity} if using \code{WorkerType} and \code{NumberOfWorkers}.

The value that can be allocated for \code{MaxCapacity} depends on whether you
are running a Python shell job or an Apache Spark ETL job:
\itemize{
\item When you specify a Python shell job
(\code{JobCommand.Name}=\"pythonshell\"), you can allocate either 0.0625
or 1 DPU. The default is 0.0625 DPU.
\item When you specify an Apache Spark ETL job
(\code{JobCommand.Name}=\"glueetl\"), you can allocate from 2 to 100
DPUs. The default is 10 DPUs. This job type cannot have a fractional
DPU allocation.
}}

\item{SecurityConfiguration}{The name of the \code{SecurityConfiguration} structure to be used with this
job.}

\item{Tags}{The tags to use with this job. You may use tags to limit access to the
job. For more information about tags in AWS Glue, see \href{https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html}{AWS Tags in AWS Glue} in
the developer guide.}

\item{NotificationProperty}{Specifies configuration properties of a job notification.}

\item{GlueVersion}{Glue version determines the versions of Apache Spark and Python that AWS
Glue supports. The Python version indicates the version supported for
jobs of type Spark.

For more information about the available AWS Glue versions and
corresponding Spark and Python versions, see \href{https://docs.aws.amazon.com/glue/latest/dg/add-job.html}{Glue version} in the
developer guide.

Jobs that are created without specifying a Glue version default to Glue
0.9.}

\item{NumberOfWorkers}{The number of workers of a defined \code{workerType} that are allocated when
a job runs.

The maximum number of workers you can define are 299 for \code{G.1X}, and 149
for \code{G.2X}.}

\item{WorkerType}{The type of predefined worker that is allocated when a job runs. Accepts
a value of Standard, G.1X, or G.2X.
\itemize{
\item For the \code{Standard} worker type, each worker provides 4 vCPU, 16 GB
of memory and a 50GB disk, and 2 executors per worker.
\item For the \code{G.1X} worker type, each worker maps to 1 DPU (4 vCPU, 16 GB
of memory, 64 GB disk), and provides 1 executor per worker. We
recommend this worker type for memory-intensive jobs.
\item For the \code{G.2X} worker type, each worker maps to 2 DPU (8 vCPU, 32 GB
of memory, 128 GB disk), and provides 1 executor per worker. We
recommend this worker type for memory-intensive jobs.
}}
}
\description{
Creates a new job definition.
}
\section{Request syntax}{
\preformatted{svc$create_job(
  Name = "string",
  Description = "string",
  LogUri = "string",
  Role = "string",
  ExecutionProperty = list(
    MaxConcurrentRuns = 123
  ),
  Command = list(
    Name = "string",
    ScriptLocation = "string",
    PythonVersion = "string"
  ),
  DefaultArguments = list(
    "string"
  ),
  Connections = list(
    Connections = list(
      "string"
    )
  ),
  MaxRetries = 123,
  AllocatedCapacity = 123,
  Timeout = 123,
  MaxCapacity = 123.0,
  SecurityConfiguration = "string",
  Tags = list(
    "string"
  ),
  NotificationProperty = list(
    NotifyDelayAfter = 123
  ),
  GlueVersion = "string",
  NumberOfWorkers = 123,
  WorkerType = "Standard"|"G.1X"|"G.2X"
)
}
}

\keyword{internal}
