% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_get_shard_iterator}
\alias{kinesis_get_shard_iterator}
\title{Gets an Amazon Kinesis shard iterator}
\usage{
kinesis_get_shard_iterator(StreamName, ShardId, ShardIteratorType,
  StartingSequenceNumber, Timestamp)
}
\arguments{
\item{StreamName}{[required] The name of the Amazon Kinesis data stream.}

\item{ShardId}{[required] The shard ID of the Kinesis Data Streams shard to get the iterator for.}

\item{ShardIteratorType}{[required] Determines how the shard iterator is used to start reading data records
from the shard.

The following are the valid Amazon Kinesis shard iterator types:
\itemize{
\item AT\_SEQUENCE\_NUMBER - Start reading from the position denoted by a
specific sequence number, provided in the value
\code{StartingSequenceNumber}.
\item AFTER\_SEQUENCE\_NUMBER - Start reading right after the position
denoted by a specific sequence number, provided in the value
\code{StartingSequenceNumber}.
\item AT\_TIMESTAMP - Start reading from the position denoted by a
specific time stamp, provided in the value \code{Timestamp}.
\item TRIM\_HORIZON - Start reading at the last untrimmed record in the
shard in the system, which is the oldest data record in the shard.
\item LATEST - Start reading just after the most recent record in the
shard, so that you always read the most recent data in the shard.
}}

\item{StartingSequenceNumber}{The sequence number of the data record in the shard from which to start
reading. Used with shard iterator type AT\_SEQUENCE\_NUMBER and
AFTER\_SEQUENCE\_NUMBER.}

\item{Timestamp}{The time stamp of the data record from which to start reading. Used with
shard iterator type AT\_TIMESTAMP. A time stamp is the Unix epoch date
with precision in milliseconds. For example,
\code{2016-04-04T19:58:46.480-00:00} or \code{1459799926.480}. If a record with
this exact time stamp does not exist, the iterator returned is for the
next (later) record. If the time stamp is older than the current trim
horizon, the iterator returned is for the oldest untrimmed data record
(TRIM\_HORIZON).}
}
\description{
Gets an Amazon Kinesis shard iterator. A shard iterator expires 5
minutes after it is returned to the requester.
}
\details{
A shard iterator specifies the shard position from which to start
reading data records sequentially. The position is specified using the
sequence number of a data record in a shard. A sequence number is the
identifier associated with every record ingested in the stream, and is
assigned when a record is put into the stream. Each stream has one or
more shards.

You must specify the shard iterator type. For example, you can set the
\code{ShardIteratorType} parameter to read exactly from the position denoted
by a specific sequence number by using the \code{AT_SEQUENCE_NUMBER} shard
iterator type. Alternatively, the parameter can read right after the
sequence number by using the \code{AFTER_SEQUENCE_NUMBER} shard iterator
type, using sequence numbers returned by earlier calls to PutRecord,
PutRecords, GetRecords, or DescribeStream. In the request, you can
specify the shard iterator type \code{AT_TIMESTAMP} to read records from an
arbitrary point in time, \code{TRIM_HORIZON} to cause \code{ShardIterator} to
point to the last untrimmed record in the shard in the system (the
oldest data record in the shard), or \code{LATEST} so that you always read
the most recent data in the shard.

When you read repeatedly from a stream, use a GetShardIterator request
to get the first shard iterator for use in your first GetRecords request
and for subsequent reads use the shard iterator returned by the
GetRecords request in \code{NextShardIterator}. A new shard iterator is
returned by every GetRecords request in \code{NextShardIterator}, which you
use in the \code{ShardIterator} parameter of the next GetRecords request.

If a GetShardIterator request is made too often, you receive a
\code{ProvisionedThroughputExceededException}. For more information about
throughput limits, see GetRecords, and \href{http://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html}{Streams Limits}
in the \emph{Amazon Kinesis Data Streams Developer Guide}.

If the shard is closed, GetShardIterator returns a valid iterator for
the last sequence number of the shard. A shard can be closed as a result
of using SplitShard or MergeShards.

GetShardIterator has a limit of five transactions per second per account
per open shard.
}
\section{Request syntax}{
\preformatted{svc$get_shard_iterator(
  StreamName = "string",
  ShardId = "string",
  ShardIteratorType = "AT_SEQUENCE_NUMBER"|"AFTER_SEQUENCE_NUMBER"|"TRIM_HORIZON"|"LATEST"|"AT_TIMESTAMP",
  StartingSequenceNumber = "string",
  Timestamp = as.POSIXct(
    "2015-01-01"
  )
)
}
}

\keyword{internal}
