% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_search_tables}
\alias{glue_search_tables}
\title{Searches a set of tables based on properties in the table metadata as
well as on the parent database}
\usage{
glue_search_tables(CatalogId, NextToken, Filters, SearchText,
  SortCriteria, MaxResults, ResourceShareType)
}
\arguments{
\item{CatalogId}{A unique identifier, consisting of \code{account_id}.}

\item{NextToken}{A continuation token, included if this is a continuation call.}

\item{Filters}{A list of key-value pairs, and a comparator used to filter the search
results. Returns all entities matching the predicate.

The \code{Comparator} member of the \code{PropertyPredicate} struct is used only
for time fields, and can be omitted for other field types. Also, when
comparing string values, such as when \code{Key=Name}, a fuzzy match
algorithm is used. The \code{Key} field (for example, the value of the \code{Name}
field) is split on certain punctuation characters, for example, -, :,
\#, etc. into tokens. Then each token is exact-match compared with the
\code{Value} member of \code{PropertyPredicate}. For example, if \code{Key=Name} and
\code{Value=link}, tables named \code{customer-link} and \code{xx-link-yy} are
returned, but \code{xxlinkyy} is not returned.}

\item{SearchText}{A string used for a text search.

Specifying a value in quotes filters based on an exact match to the
value.}

\item{SortCriteria}{A list of criteria for sorting the results by a field name, in an
ascending or descending order.}

\item{MaxResults}{The maximum number of tables to return in a single response.}

\item{ResourceShareType}{Allows you to specify that you want to search the tables shared with
your account. The allowable values are \code{FOREIGN} or \code{ALL}.
\itemize{
\item If set to \code{FOREIGN}, will search the tables shared with your
account.
\item If set to \code{ALL}, will search the tables shared with your account, as
well as the tables in yor local account.
}}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  TableList = list(
    list(
      Name = "string",
      DatabaseName = "string",
      Description = "string",
      Owner = "string",
      CreateTime = as.POSIXct(
        "2015-01-01"
      ),
      UpdateTime = as.POSIXct(
        "2015-01-01"
      ),
      LastAccessTime = as.POSIXct(
        "2015-01-01"
      ),
      LastAnalyzedTime = as.POSIXct(
        "2015-01-01"
      ),
      Retention = 123,
      StorageDescriptor = list(
        Columns = list(
          list(
            Name = "string",
            Type = "string",
            Comment = "string",
            Parameters = list(
              "string"
            )
          )
        ),
        Location = "string",
        InputFormat = "string",
        OutputFormat = "string",
        Compressed = TRUE|FALSE,
        NumberOfBuckets = 123,
        SerdeInfo = list(
          Name = "string",
          SerializationLibrary = "string",
          Parameters = list(
            "string"
          )
        ),
        BucketColumns = list(
          "string"
        ),
        SortColumns = list(
          list(
            Column = "string",
            SortOrder = 123
          )
        ),
        Parameters = list(
          "string"
        ),
        SkewedInfo = list(
          SkewedColumnNames = list(
            "string"
          ),
          SkewedColumnValues = list(
            "string"
          ),
          SkewedColumnValueLocationMaps = list(
            "string"
          )
        ),
        StoredAsSubDirectories = TRUE|FALSE,
        SchemaReference = list(
          SchemaId = list(
            SchemaArn = "string",
            SchemaName = "string",
            RegistryName = "string"
          ),
          SchemaVersionId = "string",
          SchemaVersionNumber = 123
        )
      ),
      PartitionKeys = list(
        list(
          Name = "string",
          Type = "string",
          Comment = "string",
          Parameters = list(
            "string"
          )
        )
      ),
      ViewOriginalText = "string",
      ViewExpandedText = "string",
      TableType = "string",
      Parameters = list(
        "string"
      ),
      CreatedBy = "string",
      IsRegisteredWithLakeFormation = TRUE|FALSE,
      TargetTable = list(
        CatalogId = "string",
        DatabaseName = "string",
        Name = "string"
      ),
      CatalogId = "string"
    )
  )
)
}
}
\description{
Searches a set of tables based on properties in the table metadata as
well as on the parent database. You can search against text or filter
conditions.

You can only get tables that you have access to based on the security
policies defined in Lake Formation. You need at least a read-only access
to the table for it to be returned. If you do not have access to all the
columns in the table, these columns will not be searched against when
returning the list of tables back to you. If you have access to the
columns but not the data in the columns, those columns and the
associated metadata for those columns will be included in the search.
}
\section{Request syntax}{
\preformatted{svc$search_tables(
  CatalogId = "string",
  NextToken = "string",
  Filters = list(
    list(
      Key = "string",
      Value = "string",
      Comparator = "EQUALS"|"GREATER_THAN"|"LESS_THAN"|"GREATER_THAN_EQUALS"|"LESS_THAN_EQUALS"
    )
  ),
  SearchText = "string",
  SortCriteria = list(
    list(
      FieldName = "string",
      Sort = "ASC"|"DESC"
    )
  ),
  MaxResults = 123,
  ResourceShareType = "FOREIGN"|"ALL"
)
}
}

\keyword{internal}
