% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalytics_operations.R
\name{kinesisanalytics_add_application_cloud_watch_logging_option}
\alias{kinesisanalytics_add_application_cloud_watch_logging_option}
\title{Adds a CloudWatch log stream to monitor application configuration errors}
\usage{
kinesisanalytics_add_application_cloud_watch_logging_option(
  ApplicationName, CurrentApplicationVersionId, CloudWatchLoggingOption)
}
\arguments{
\item{ApplicationName}{[required] The Kinesis Analytics application name.}

\item{CurrentApplicationVersionId}{[required] The version ID of the Kinesis Analytics application.}

\item{CloudWatchLoggingOption}{[required] Provides the CloudWatch log stream Amazon Resource Name (ARN) and the
IAM role ARN. Note: To write application messages to CloudWatch, the IAM
role that is used must have the \code{PutLogEvents} policy action enabled.}
}
\description{
Adds a CloudWatch log stream to monitor application configuration
errors. For more information about using CloudWatch log streams with
Amazon Kinesis Analytics applications, see \href{http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html}{Working with Amazon CloudWatch Logs}.
}
\section{Request syntax}{
\preformatted{svc$add_application_cloud_watch_logging_option(
  ApplicationName = "string",
  CurrentApplicationVersionId = 123,
  CloudWatchLoggingOption = list(
    LogStreamARN = "string",
    RoleARN = "string"
  )
)
}
}

\keyword{internal}
