% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PC.Mk.II.Lightweight.R
\name{PC.Mk.II.Lightweight}
\alias{PC.Mk.II.Lightweight}
\title{PC Mk. II Lightweight Function}
\usage{
PC.Mk.II.Lightweight(X, Y, E, tau, metric, h, weighted)
}
\arguments{
\item{X}{A numeric vector representing the first time series.}

\item{Y}{A numeric vector representing the second time series.}

\item{E}{The embedding dimension, which influences the number of dimensions in which the time series is reconstructed for analysis.}

\item{tau}{The time delay used in reconstructing the time series in the embedded space.}

\item{metric}{A character string indicating the distance metric to be used (e.g., 'euclidean', 'maximum').}

\item{h}{The prediction horizon, representing the number of steps ahead for which predictions are needed.}

\item{weighted}{A logical indicating whether to use a weighted approach in the causality strength calculations.}
}
\value{
A data frame with columns for total, positive, negative, and dark causality percentages across evaluated time points, giving insights into the nature of causality between the time series.
}
\description{
This function implements the Pattern Causality Model Mk. II for lightweight analysis of causal interactions between two time series using pattern and signature spaces. It assesses causality through reconstructed state spaces and hashed pattern analysis.
}
\examples{
data(climate)
X <- climate$AO
Y <- climate$AAO
result <- PC.Mk.II.Lightweight(X, Y, E = 3, tau = 1, metric = "euclidean", h = 2, weighted = TRUE)
print(result)
}
