% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasource.R
\name{ds_write_tables}
\alias{ds_write_tables}
\title{Write FHIR data to managed tables}
\usage{
ds_write_tables(ds, schema = NULL, save_mode = SaveMode$OVERWRITE)
}
\arguments{
\item{ds}{The DataSource object.}

\item{schema}{The name of the schema to write the tables to.}

\item{save_mode}{The save mode to use when writing the data - "overwrite" will overwrite any
existing data, "merge" will merge the new data with the existing data based on resource ID.}
}
\value{
A list with element \code{file_infos}, containing a list of files created.
  Each file has \code{fhir_resource_type} and \code{absolute_url}.
}
\description{
Writes the data from a data source to a set of tables in the Spark catalog.
}
\examples{
\dontshow{if (pathling_is_spark_installed()) withAutoprint(\{ # examplesIf}
# Create a temporary warehouse location, which will be used when we call ds_write_tables().
temp_dir_path <- tempfile()
dir.create(temp_dir_path)
sc <- sparklyr::spark_connect(master = "local[*]", config = list(
  "sparklyr.shell.conf" = c(
    paste0("spark.sql.warehouse.dir=", temp_dir_path),
    "spark.sql.extensions=io.delta.sql.DeltaSparkSessionExtension",
    "spark.sql.catalog.spark_catalog=org.apache.spark.sql.delta.catalog.DeltaCatalog"
  )
), version = pathling_spark_info()$spark_version)

pc <- pathling_connect(sc)
data_source <- pc \%>\% pathling_read_ndjson(pathling_examples("ndjson"))

# Write the data to a set of Spark tables in the 'default' database.
data_source \%>\% ds_write_tables("default", save_mode = SaveMode$MERGE)

pathling_disconnect(pc)
unlink(temp_dir_path, recursive = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://pathling.csiro.au/docs/libraries/io#managed-tables-1}{Pathling documentation - Writing managed tables}

\code{\link{SaveMode}}

Other data sink functions: 
\code{\link{ds_write_delta}()},
\code{\link{ds_write_ndjson}()},
\code{\link{ds_write_parquet}()}
}
\concept{data sink functions}
