% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{term_gene_heatmap}
\alias{term_gene_heatmap}
\title{Create Terms by Genes Heatmap}
\usage{
term_gene_heatmap(
  result_df,
  genes_df,
  num_terms = 10,
  use_description = FALSE,
  low = "red",
  mid = "black",
  high = "green",
  legend_title = "change",
  sort_terms_by_p = FALSE,
  ...
)
}
\arguments{
\item{result_df}{A dataframe of pathfindR results that must contain the following columns: \describe{
  \item{Term_Description}{Description of the enriched term (necessary if \code{use_description = TRUE})}
  \item{ID}{ID of the enriched term (necessary if \code{use_description = FALSE})}
  \item{lowest_p}{the highest adjusted-p value of the given term over all iterations}
  \item{Up_regulated}{the up-regulated genes in the input involved in the given term's gene set, comma-separated}
  \item{Down_regulated}{the down-regulated genes in the input involved in the given term's gene set, comma-separated}
}}

\item{genes_df}{the input data that was used with \code{\link{run_pathfindR}}.
  It must be a data frame with 3 columns: \enumerate{
  \item Gene Symbol (Gene Symbol)
  \item Change value, e.g. log(fold change) (optional)
  \item p value, e.g. adjusted p value associated with differential expression
} The change values in this data frame are used to color the affected genes}

\item{num_terms}{Number of top enriched terms to use while creating the plot. Set to \code{NULL} to use
all enriched terms (default = 10)}

\item{use_description}{Boolean argument to indicate whether term descriptions
(in the "Term_Description" column) should be used. (default = \code{FALSE})}

\item{low}{a string indicating the color of 'low' values in the coloring gradient (default = 'green')}

\item{mid}{a string indicating the color of 'mid' values in the coloring gradient (default = 'black')}

\item{high}{a string indicating the color of 'high' values in the coloring gradient (default = 'red')}

\item{legend_title}{legend title (defaut = "change")}

\item{sort_terms_by_p}{boolean to indicate whether to sort terms by 'lowest_p'
(\code{TRUE}) or by number of genes (\code{FALSE}) (default = \code{FALSE})}

\item{...}{additional arguments for \code{\link{input_processing}} (used if
\code{genes_df} is provided)}
}
\value{
a ggplot2 object of a heatmap where rows are enriched terms and
columns are involved input genes. If \code{genes_df} is provided, colors of
the tiles indicate the change values.
}
\description{
Create Terms by Genes Heatmap
}
\examples{
term_gene_heatmap(example_pathfindR_output, num_terms = 3)
}
