% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_functions.R
\name{input_testing}
\alias{input_testing}
\title{Input Testing}
\usage{
input_testing(input, p_val_threshold, org_dir = NULL)
}
\arguments{
\item{input}{the input data that pathfindR uses. The input must be a data
  frame with three columns: \enumerate{
  \item Gene Symbol (HGNC Gene Symbol)
  \item Change value, e.g. log(fold change) (Not obligatory)
  \item adjusted p value associated with test, e.g. differential expression/methylation
}}

\item{p_val_threshold}{the adjusted-p value threshold to use when filtering
the input data frame. Must a numeric value between 0 and 1.}

\item{org_dir}{path/to/original/directory, supplied by run_pathfindR (default = NULL)}
}
\value{
Only checks if the input and the threshold follows the required
  specifications.
}
\description{
Input Testing
}
\examples{
input_testing(RA_input, 0.05)
}
\seealso{
See \code{\link{run_pathfindR}} for the wrapper function of the
  pathfindR workflow
}
