% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{fuzzy_pw_clustering}
\alias{fuzzy_pw_clustering}
\title{Heuristic Fuzzy Multiple-linkage Partitioning of Pathways}
\usage{
fuzzy_pw_clustering(kappa_mat, enrichment_res, kappa_threshold = 0.35,
  use_names = FALSE)
}
\arguments{
\item{kappa_mat}{matrix of kappa statistics (output of `create_kappa_matrix`)}

\item{enrichment_res}{data frame of pathway enrichment results}

\item{kappa_threshold}{threshold for kappa statistics, defining strong relation (default = 0.35)}

\item{use_names}{boolean to indicate whether to use pathway names instead of IDs (default = FALSE, i.e. use IDs)}
}
\value{
a boolean matrix of cluster assignments. Each row corresponds to a term,
each column corresponds to a cluster.
}
\description{
Heuristic Fuzzy Multiple-linkage Partitioning of Pathways
}
\details{
The fuzzy clustering algorithm was implemented based on:
Huang DW, Sherman BT, Tan Q, et al. The DAVID Gene Functional
Classification Tool: a novel biological module-centric algorithm to
functionally analyze large gene lists. Genome Biol. 2007;8(9):R183.
}
\examples{
\dontrun{
fuzzy_pw_clustering(kappa_mat, enrichment_res)
fuzzy_pw_clustering(kappa_mat, enrichment_res, kappa_threshold = 0.45)
}
}
