% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_etopo.R
\name{download_etopo}
\alias{download_etopo}
\title{Download the ETOPO Global relief model}
\usage{
download_etopo(path = NULL, resolution = 1)
}
\arguments{
\item{path}{character. Path where to download the data to. If left NULL, the data
will be downloaded from the directory returned by \code{\link[=get_data_path]{get_data_path()}}, and automatically
named \verb{etopo2022_\{resolution\}s_v1.nc}}

\item{resolution}{numeric resolution in arc-minute (one of 0.5, or 1).
Defaults to 1 arc-minute.}
}
\value{
a dataframe produced by \code{\link[curl:multi_download]{curl::multi_download()}} with information about
the download (including error codes)
}
\description{
This function downloads the ETOPO2022 global relief model at
0.5 or 1 arc-minute (i.e. 30 or 60 arc-seconds) resolution.
This is a large file (>1Gb).
}
\keyword{internal}
