% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reducers.R
\name{reduce_kmeans}
\alias{reduce_kmeans}
\title{Reduce selected variables to scaled means}
\usage{
reduce_kmeans(.partition_step, search = c("binary", "linear"), n_hits = 4)
}
\arguments{
\item{.partition_step}{a \code{partition_step} object}

\item{search}{The search method. Binary search is generally more efficient
but linear search can be faster in very low dimensions.}

\item{n_hits}{In linear search method, the number of iterations that should
be under the threshold before reducing; useful for preventing false
positives.}
}
\value{
a \code{partition_step} object
}
\description{
Reducers are functions that tell the partition algorithm how
to reduce the data. \code{\link[=as_reducer]{as_reducer()}} is a helper function to create new
reducers to be used in \code{partitioner}s. \code{partitioner}s can be created with
\code{\link[=as_partitioner]{as_partitioner()}}.

\code{reduce_kmeans()} is efficient in that it doesn't reduce until
the closest \code{k} to the information threshold is found.
}
\seealso{
Other reducers: 
\code{\link{as_reducer}()},
\code{\link{reduce_first_component}()},
\code{\link{reduce_scaled_mean}()}
}
\concept{reducers}
