% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_helpers.R
\name{bootstrap_all}
\alias{bootstrap_all}
\title{Parametric bootstrapping}
\usage{
bootstrap_all(
  nboot,
  mod,
  R2_type,
  all_comb,
  partition,
  data_mod,
  allow_neg_r2,
  parallel,
  expct,
  overdisp_name
)
}
\arguments{
\item{nboot}{Number of parametric bootstrap iterations for confidence interval estimation
(defaults to NULL, i.e. no bootstrapping). Larger numbers of bootstraps give a better
asymptotic CI, but may be time-consuming. Bootstrapping can be switched on by setting
\code{nboot = 1000}.}

\item{mod}{merMod object, lme4 fit}

\item{R2_type}{"marginal" or "conditional" R2. With "marginal", the variance explained
by fixed effects is calculated. With "conditional", the variance explained by
both fixed and random effects is calculated.}

\item{all_comb}{list of predictor combinations}

\item{partition}{TRUE or FALSE}

\item{data_mod}{Data for model}

\item{allow_neg_r2}{Calculating part R2 involves fitting two models, one with
and one without the predictor of interest. In cases where the predictor
has little association with the response, the resulting part R2 value
can become negative. By default we set negative values to 0, but by
setting this parameter to TRUE, R2 values can become negative.}

\item{parallel}{If TRUE, computation uses \code{future} within \code{furrr::map} which allows
parallelisation. However, it is necessary to specify a plan before running
\code{partR2()}. To see which options you have, check \code{?future::plan} and have
a look at our vignette for details. When running RStudio,
usually \code{plan(multisession, workers = 4)} is a good choice,
when you want to use 4 cores. To detect how many cores you have, use
\code{parallel::detectCores()}. If no plan is specified, \code{partR2} will simply run
sequentially.}

\item{expct}{A string specifying the method for estimating the expectation in Poisson models
with log link and in Binomial models with logit link (in all other cases the argument is ignored).
The only valid terms are 'meanobs', 'latent', 'none' (and 'liability for binary and proportion data).
With the default 'meanobs', the expectation is estimated as the mean of the observations in the sample.
With 'latent', the expectation is estimated from estimates of the intercept and variances on the link scale.
While this is a preferred solution, it is susceptible to the distribution of fixed effect covariates and gives
appropriate results typically only when all covariances are centered to zero. With 'liability'
estimates follow formulae as presented in Nakagawa & Schielzeth (2010). With 'none', R2 is calculated
without distribution specific variance in the denominator.}

\item{overdisp_name}{Name of overdispersion term}
}
\value{
Bootstrap samples for all statistics, plus associated warnings
}
\description{
Parametric bootstrapping
}
\keyword{internal}
