% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_reg_glm.R
\name{details_logistic_reg_glm}
\alias{details_logistic_reg_glm}
\title{Logistic regression via glm}
\description{
\code{\link[stats:glm]{stats::glm()}} fits a generalized linear model for binary outcomes. A
linear combination of the predictors is used to model the log odds of an
event.
}
\details{
For this engine, there is a single mode: classification
\subsection{Tuning Parameters}{

This engine has no tuning parameters but you can set the \code{family}
parameter (and/or \code{link}) as an engine argument (see below).
}

\subsection{Translation from parsnip to the original package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{logistic_reg() \%>\% 
  set_engine("glm") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Logistic Regression Model Specification (classification)
## 
## Computational engine: glm 
## 
## Model fit template:
## stats::glm(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     family = stats::binomial)
}\if{html}{\out{</div>}}

To use a non-default \code{family} and/or \code{link}, pass in as an argument to
\code{set_engine()}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{logistic_reg() \%>\% 
  set_engine("glm", family = stats::binomial(link = "probit")) \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Logistic Regression Model Specification (classification)
## 
## Engine-Specific Arguments:
##   family = stats::binomial(link = "probit")
## 
## Computational engine: glm 
## 
## Model fit template:
## stats::glm(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     family = stats::binomial(link = "probit"))
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.

\emph{However}, the documentation in \code{\link[stats:glm]{stats::glm()}} assumes
that is specific type of case weights are being used:“Non-NULL weights
can be used to indicate that different observations have different
dispersions (with the values in weights being inversely proportional to
the dispersions); or equivalently, when the elements of weights are
positive integers \code{w_i}, that each response \code{y_i} is the mean of \code{w_i}
unit-weight observations. For a binomial GLM prior weights are used to
give the number of trials when the response is the proportion of
successes: they would rarely be used for a Poisson GLM.”
}

\subsection{Saving fitted model objects}{

This model object contains data that are not required to make
predictions. When saving the model for the purpose of prediction, the
size of the saved object might be substantially reduced by using
functions from the \href{https://butcher.tidymodels.org}{butcher} package.
}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#logistic-reg-glm}{examples}
for \code{logistic_reg()} with the \code{"glm"} engine.
}

\subsection{References}{
\itemize{
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}. Springer.
}
}
}
\keyword{internal}
