% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_reg_glmnet.R
\name{details_poisson_reg_glmnet}
\alias{details_poisson_reg_glmnet}
\title{Poisson regression via glmnet}
\description{
\code{glmnet::glmnet()} uses penalized maximum likelihood to fit a model for
count data.
}
\details{
For this engine, there is a single mode: regression
\subsection{Tuning Parameters}{

This model has 2 tuning parameters:
\itemize{
\item \code{penalty}: Amount of Regularization (type: double, default: see
below)
\item \code{mixture}: Proportion of Lasso Penalty (type: double, default: 1.0)
}

The \code{penalty} parameter has no default and requires a single numeric
value. For more details about this, and the \code{glmnet} model in general,
see \link{glmnet-details}. As for \code{mixture}:
\itemize{
\item \code{mixture = 1} specifies a pure lasso model,
\item \code{mixture = 0} specifies a ridge regression model, and
\item \verb{0 < mixture < 1} specifies an elastic net model, interpolating
lasso and ridge.
}
}

\subsection{Translation from parsnip to the original package}{

The \strong{poissonreg} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(poissonreg)

poisson_reg(penalty = double(1), mixture = double(1)) \%>\% 
  set_engine("glmnet") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Poisson Regression Model Specification (regression)
## 
## Main Arguments:
##   penalty = 0
##   mixture = double(1)
## 
## Computational engine: glmnet 
## 
## Model fit template:
## glmnet::glmnet(x = missing_arg(), y = missing_arg(), weights = missing_arg(), 
##     alpha = double(1), family = "poisson")
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.

Predictors should have the same scale. One way to achieve this is to
center and scale each so that each predictor has mean zero and a
variance of one. By default, \code{glmnet::glmnet()} uses the argument
\code{standardize = TRUE} to center and scale the data.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.
}
}
\keyword{internal}
